/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.Session;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTimestampWithTimeZone {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2020, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1)).isEqualTo(this.timestampWithTimeZone(1, 2020, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2)).isEqualTo(this.timestampWithTimeZone(2, 2020, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2020, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4)).isEqualTo(this.timestampWithTimeZone(4, 2020, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5)).isEqualTo(this.timestampWithTimeZone(5, 2020, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6)).isEqualTo(this.timestampWithTimeZone(6, 2020, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7)).isEqualTo(this.timestampWithTimeZone(7, 2020, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8)).isEqualTo(this.timestampWithTimeZone(8, 2020, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).isEqualTo(this.timestampWithTimeZone(9, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10)).isEqualTo(this.timestampWithTimeZone(10, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11)).isEqualTo(this.timestampWithTimeZone(11, 2020, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12)).isEqualTo(this.timestampWithTimeZone(12, 2020, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        Assertions.assertThatThrownBy(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890123 Asia/Kathmandu'")::evaluate).hasMessage("line 1:12: TIMESTAMP WITH TIME ZONE precision must be in range [0, 12]: 13");
        Assertions.assertThatThrownBy(this.assertions.expression("TIMESTAMP '2020-13-01 Asia/Kathmandu'")::evaluate).hasMessage("line 1:12: '2020-13-01 Asia/Kathmandu' is not a valid TIMESTAMP literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 1500, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 1500, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 1500, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 1500, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 1500, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 1500, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 1500, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 1500, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 1500, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 1500, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 1500, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 1500, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 1500, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, -12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, -12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, -12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, -12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, -12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, -12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, -12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, -12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, -12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, -12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, -12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, -12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, -12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2020, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1)).isEqualTo(this.timestampWithTimeZone(1, 2020, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2)).isEqualTo(this.timestampWithTimeZone(2, 2020, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2020, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4)).isEqualTo(this.timestampWithTimeZone(4, 2020, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5)).isEqualTo(this.timestampWithTimeZone(5, 2020, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6)).isEqualTo(this.timestampWithTimeZone(6, 2020, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7)).isEqualTo(this.timestampWithTimeZone(7, 2020, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8)).isEqualTo(this.timestampWithTimeZone(8, 2020, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).isEqualTo(this.timestampWithTimeZone(9, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10)).isEqualTo(this.timestampWithTimeZone(10, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11)).isEqualTo(this.timestampWithTimeZone(11, 2020, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 -08:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12)).isEqualTo(this.timestampWithTimeZone(12, 2020, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"-08:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2020, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1)).isEqualTo(this.timestampWithTimeZone(1, 2020, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2)).isEqualTo(this.timestampWithTimeZone(2, 2020, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2020, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4)).isEqualTo(this.timestampWithTimeZone(4, 2020, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5)).isEqualTo(this.timestampWithTimeZone(5, 2020, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6)).isEqualTo(this.timestampWithTimeZone(6, 2020, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7)).isEqualTo(this.timestampWithTimeZone(7, 2020, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8)).isEqualTo(this.timestampWithTimeZone(8, 2020, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).isEqualTo(this.timestampWithTimeZone(9, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10)).isEqualTo(this.timestampWithTimeZone(10, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11)).isEqualTo(this.timestampWithTimeZone(11, 2020, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 -00:35'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12)).isEqualTo(this.timestampWithTimeZone(12, 2020, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"-00:35")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-01-02 +07:09'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 0, 0, 0, 0L, TimeZoneKey.getTimeZoneKey((String)"+07:09")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-1-2 3:4:5.321+07:09'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2001, 1, 2, 3, 4, 5, 321000000000L, TimeZoneKey.getTimeZoneKey((String)"+07:09")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-1-2 3:4:5+07:09'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 3, 4, 5, 0L, TimeZoneKey.getTimeZoneKey((String)"+07:09")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-1-2 3:4+07:09'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 3, 4, 0, 0L, TimeZoneKey.getTimeZoneKey((String)"+07:09")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-1-2 +07:09'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 0, 0, 0, 0L, TimeZoneKey.getTimeZoneKey((String)"+07:09")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-01-02 03:04:05.321 Europe/Berlin'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2001, 1, 2, 3, 4, 5, 321000000000L, TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-01-02 03:04:05 Europe/Berlin'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 3, 4, 5, 0L, TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-01-02 03:04 Europe/Berlin'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 3, 4, 0, 0L, TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TIMESTAMP '2001-01-02 Europe/Berlin'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2001, 1, 2, 0, 0, 0, 0L, TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TIMESTAMP '123001-01-02 03:04:05.321 Europe/Berlin'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '123001-01-02 03:04:05.321 Europe/Berlin' is not a valid TIMESTAMP literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TIMESTAMP '+123001-01-02 03:04:05.321 Europe/Berlin'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '+123001-01-02 03:04:05.321 Europe/Berlin' is not a valid TIMESTAMP literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TIMESTAMP '-123001-01-02 03:04:05.321 Europe/Berlin'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '-123001-01-02 03:04:05.321 Europe/Berlin' is not a valid TIMESTAMP literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TIMESTAMP '2020-13-01-12'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2020-13-01-12' is not a valid TIMESTAMP literal");
    }

    @Test
    public void testPlusInterval() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' hour")))).matches("TIMESTAMP '2001-01-22 06:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' hour", "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'")))).matches("TIMESTAMP '2001-01-22 06:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' day")))).matches("TIMESTAMP '2001-01-25 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' day", "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'")))).matches("TIMESTAMP '2001-01-25 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' month")))).matches("TIMESTAMP '2001-04-22 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' month", "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'")))).matches("TIMESTAMP '2001-04-22 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' year")))).matches("TIMESTAMP '2004-01-22 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' year", "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'")))).matches("TIMESTAMP '2004-01-22 03:04:05.321 +05:09'");
    }

    @Test
    public void testMinusInterval() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' day")))).matches("TIMESTAMP '2001-01-19 03:04:05.321 +05:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", "INTERVAL '3' month")))).matches("TIMESTAMP '2000-10-22 03:04:05.321 +05:09'");
    }

    @Test
    public void testCurrentTimestamp() {
        Session session = this.assertions.sessionBuilder().setSystemProperty("session_start_time", ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()).toInstant().toString()).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111110 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111000 Pacific/Apia'");
        session = this.assertions.sessionBuilder().setSystemProperty("session_start_time", ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 555555555, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()).toInstant().toString()).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555550 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555500 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555000 Pacific/Apia'");
    }

    @Test
    public void testCastToDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
    }

    @Test
    public void testCastFromDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000000 Pacific/Apia'");
    }

    @Test
    public void testCastToTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.10000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.10000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.10000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.100000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.12000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.120000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1200000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.120000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1200000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.120000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.12340'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.123400'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1234000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12340000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123400000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12340000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123400000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.123450'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1234500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12345000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123450000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123450000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1234560'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12345600'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123456000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234560000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345600000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.12345670'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123456700'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234567000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345670000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456700000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.123456780'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234567800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345678000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456780000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345678900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456789000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.12345678910'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456789100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIME(12))")))).matches("TIME '12:34:56.123456789120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(11))")))).matches("TIME '00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45 America/Los_Angeles' AS TIME(0))")))).matches("TIME '01:23:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1 America/Los_Angeles' AS TIME(1))")))).matches("TIME '01:23:45.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12 America/Los_Angeles' AS TIME(2))")))).matches("TIME '01:23:45.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123 America/Los_Angeles' AS TIME(3))")))).matches("TIME '01:23:45.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234 America/Los_Angeles' AS TIME(4))")))).matches("TIME '01:23:45.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345 America/Los_Angeles' AS TIME(5))")))).matches("TIME '01:23:45.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456 America/Los_Angeles' AS TIME(6))")))).matches("TIME '01:23:45.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567 America/Los_Angeles' AS TIME(7))")))).matches("TIME '01:23:45.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678 America/Los_Angeles' AS TIME(8))")))).matches("TIME '01:23:45.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789 America/Los_Angeles' AS TIME(9))")))).matches("TIME '01:23:45.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567891 America/Los_Angeles' AS TIME(10))")))).matches("TIME '01:23:45.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678912 America/Los_Angeles' AS TIME(11))")))).matches("TIME '01:23:45.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789123 America/Los_Angeles' AS TIME(12))")))).matches("TIME '01:23:45.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45 America/Los_Angeles' AS TIME(0))")))).matches("TIME '03:23:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1 America/Los_Angeles' AS TIME(1))")))).matches("TIME '03:23:45.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12 America/Los_Angeles' AS TIME(2))")))).matches("TIME '03:23:45.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123 America/Los_Angeles' AS TIME(3))")))).matches("TIME '03:23:45.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234 America/Los_Angeles' AS TIME(4))")))).matches("TIME '03:23:45.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345 America/Los_Angeles' AS TIME(5))")))).matches("TIME '03:23:45.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456 America/Los_Angeles' AS TIME(6))")))).matches("TIME '03:23:45.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234567 America/Los_Angeles' AS TIME(7))")))).matches("TIME '03:23:45.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345678 America/Los_Angeles' AS TIME(8))")))).matches("TIME '03:23:45.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456789 America/Los_Angeles' AS TIME(9))")))).matches("TIME '03:23:45.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234567891 America/Los_Angeles' AS TIME(10))")))).matches("TIME '03:23:45.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345678912 America/Los_Angeles' AS TIME(11))")))).matches("TIME '03:23:45.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456789123 America/Los_Angeles' AS TIME(12))")))).matches("TIME '03:23:45.123456789123'");
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.12+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.123+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234567+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345678+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456789+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234567891+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345678912+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456789123+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.00000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.0000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.00000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.000000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.10+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.100+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.10000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.100000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.10000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.100000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.10000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.100000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.120+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1200+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.12000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.120000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1200000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.120000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1200000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.120000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1230+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.12300+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.123000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1230000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12300000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1230000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12300000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.12340+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.123400+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12340000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123400000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12340000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123400000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.123450+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234500+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123450000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234500000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123450000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234560+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345600+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234560000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345600000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345670+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456700+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234567000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345670000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456700000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456780+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234567800+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345678000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456780000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1234567890+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345678900+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456789000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.12345678910+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456789100+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '12:34:56.123456789120+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.1+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.11+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.1111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.11111111111+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '12:34:57+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '12:34:56.6+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '12:34:56.56+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '12:34:56.556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '12:34:56.5556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '12:34:56.55556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '12:34:56.555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.55555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.55555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.55555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '12:34:56.55555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '12:34:56.555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '12:34:56.5555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '12:34:56.55555555556+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '00:00:00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '00:00:00.0+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '00:00:00.00+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '00:00:00.000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '00:00:00.000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '00:00:00.0000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999 Asia/Kathmandu' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '00:00:00.00000000000+05:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45 America/Los_Angeles' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '01:23:45-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1 America/Los_Angeles' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '01:23:45.1-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12 America/Los_Angeles' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '01:23:45.12-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123 America/Los_Angeles' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '01:23:45.123-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234 America/Los_Angeles' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345 America/Los_Angeles' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456 America/Los_Angeles' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567 America/Los_Angeles' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678 America/Los_Angeles' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789 America/Los_Angeles' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567891 America/Los_Angeles' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567891-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678912 America/Los_Angeles' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678912-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789123 America/Los_Angeles' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789123-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45 America/Los_Angeles' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '03:23:45-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1 America/Los_Angeles' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '03:23:45.1-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12 America/Los_Angeles' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '03:23:45.12-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123 America/Los_Angeles' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '03:23:45.123-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234 America/Los_Angeles' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '03:23:45.1234-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345 America/Los_Angeles' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '03:23:45.12345-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456 America/Los_Angeles' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '03:23:45.123456-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234567 America/Los_Angeles' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '03:23:45.1234567-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345678 America/Los_Angeles' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '03:23:45.12345678-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456789 America/Los_Angeles' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '03:23:45.123456789-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.1234567891 America/Los_Angeles' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '03:23:45.1234567891-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.12345678912 America/Los_Angeles' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '03:23:45.12345678912-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 03:23:45.123456789123 America/Los_Angeles' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '03:23:45.123456789123-08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45 -08:35' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '01:23:45-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1 -08:35' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '01:23:45.1-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12 -08:35' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '01:23:45.12-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123 -08:35' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '01:23:45.123-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234 -08:35' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345 -08:35' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456 -08:35' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567 -08:35' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678 -08:35' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789 -08:35' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567891 -08:35' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567891-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678912 -08:35' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678912-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789123 -08:35' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789123-08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45 -00:35' AS TIME(0) WITH TIME ZONE)")))).matches("TIME '01:23:45-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1 -00:35' AS TIME(1) WITH TIME ZONE)")))).matches("TIME '01:23:45.1-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12 -00:35' AS TIME(2) WITH TIME ZONE)")))).matches("TIME '01:23:45.12-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123 -00:35' AS TIME(3) WITH TIME ZONE)")))).matches("TIME '01:23:45.123-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234 -00:35' AS TIME(4) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345 -00:35' AS TIME(5) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456 -00:35' AS TIME(6) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567 -00:35' AS TIME(7) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678 -00:35' AS TIME(8) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789 -00:35' AS TIME(9) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.1234567891 -00:35' AS TIME(10) WITH TIME ZONE)")))).matches("TIME '01:23:45.1234567891-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.12345678912 -00:35' AS TIME(11) WITH TIME ZONE)")))).matches("TIME '01:23:45.12345678912-00:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-03-08 01:23:45.123456789123 -00:35' AS TIME(12) WITH TIME ZONE)")))).matches("TIME '01:23:45.123456789123-00:35'");
    }

    @Test
    public void testCastToTimestamp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9 UTC' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99 UTC' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999 UTC' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999 UTC' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999 UTC' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999 UTC' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999 UTC' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999 UTC' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999 UTC' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999999 UTC' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999999 UTC' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999999 UTC' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999999 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999999 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999999 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678910'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.4 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.94 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.994 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9994 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99994 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999994 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999994 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999994 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999994 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999994 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999994 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.9999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999994 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.99999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5 Asia/Kathmandu' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.95 Asia/Kathmandu' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:57.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.995 Asia/Kathmandu' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:57.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9995 Asia/Kathmandu' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:57.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99995 Asia/Kathmandu' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:57.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999995 Asia/Kathmandu' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:57.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999995 Asia/Kathmandu' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:57.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999995 Asia/Kathmandu' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:57.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999995 Asia/Kathmandu' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:57.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.9999999995 Asia/Kathmandu' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:57.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.99999999995 Asia/Kathmandu' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:57.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.999999999995 Asia/Kathmandu' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:57.00000000000'");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567890 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678901 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789012 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567890 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567890 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678901 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678901 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789012 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789012 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("+12001-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("-12001-05-01 12:34:56 Asia/Kathmandu");
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
    }

    @Test
    public void testLowerDigitsZeroed() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000 Asia/Kathmandu'");
    }

    @Test
    public void testRoundDown() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu'");
    }

    @Test
    public void testRoundUp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.5 UTC' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.95 UTC' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.995 UTC' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9995 UTC' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99995 UTC' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999995 UTC' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9999995 UTC' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99999995 UTC' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999995 UTC' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9999999995 UTC' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99999999995 UTC' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999995 UTC' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000000 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999 UTC' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000000 UTC'");
    }

    @Test
    public void testToIso8601() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-05-01T12:34:56+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-05-01T12:34:56.1+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-05-01T12:34:56.12+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-05-01T12:34:56.123+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-05-01T12:34:56.1234+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-05-01T12:34:56.12345+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-05-01T12:34:56.123456+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)36)).isEqualTo("2020-05-01T12:34:56.1234567+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)37)).isEqualTo("2020-05-01T12:34:56.12345678+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("2020-05-01T12:34:56.123456789+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("2020-05-01T12:34:56.1234567890+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("2020-05-01T12:34:56.12345678901+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-05-01T12:34:56.123456789012+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-11-01T01:00:00-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.1 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-11-01T01:00:00.1-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.12 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-11-01T01:00:00.12-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.00 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-11-01T01:00:00.00-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.123 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-11-01T01:00:00.123-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.1234 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-11-01T01:00:00.1234-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.12345 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-11-01T01:00:00.12345-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.123456 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-11-01T01:00:00.123456-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.1234567 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)36)).isEqualTo("2020-11-01T01:00:00.1234567-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.12345678 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)37)).isEqualTo("2020-11-01T01:00:00.12345678-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.123456789 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("2020-11-01T01:00:00.123456789-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.1234567890 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("2020-11-01T01:00:00.1234567890-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.12345678901 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("2020-11-01T01:00:00.12345678901-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.123456789012 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-11-01T01:00:00.123456789012-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-11-01 07:00:00.000000000000 UTC' AT TIME ZONE 'America/Chicago')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-11-01T01:00:00.000000000000-06:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-05-01T12:34:56Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-05-01T12:34:56.1Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-05-01T12:34:56.12Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-05-01T12:34:56.123Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-05-01T12:34:56.1234Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-05-01T12:34:56.12345Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-05-01T12:34:56.123456Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)36)).isEqualTo("2020-05-01T12:34:56.1234567Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)37)).isEqualTo("2020-05-01T12:34:56.12345678Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("2020-05-01T12:34:56.123456789Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567890 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("2020-05-01T12:34:56.1234567890Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678901 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("2020-05-01T12:34:56.12345678901Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789012 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-05-01T12:34:56.123456789012Z");
    }

    @Test
    public void testFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
    }

    @Test
    public void testFormatDateTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.000 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.100 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.110 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.000 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.500 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.550 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.555 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
    }

    @Test
    public void testDateFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.100000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.110000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.500000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.550000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.555000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
    }

    @Test
    public void testDateDiff() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2 Asia/Kathmandu')")))).matches("BIGINT '1100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22 Asia/Kathmandu')")))).matches("BIGINT '1110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9 Asia/Kathmandu')")))).matches("BIGINT '1800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99 Asia/Kathmandu')")))).matches("BIGINT '1880'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.1 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.11 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.1111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.11111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.1111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.11111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.1111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('day', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '1682'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.1 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.11 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.1111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.11111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.1111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.11111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.1111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('week', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '240'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.1 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.11 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.1111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.11111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.1111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.11111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.1111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('month', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.1 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.11 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.1111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.11111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.1111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.11111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.1111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('quarter', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '18'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.1 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.11 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.1111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.11111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.1111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.11111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.1111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.9999999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.11111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.99999999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_diff('year', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")))).matches("BIGINT '4'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("date_diff('foo', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("'foo' is not a valid TIMESTAMP field");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("date_diff('foo', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("'foo' is not a valid TIMESTAMP field");
    }

    @Test
    public void testDateAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1000, TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.1 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.11 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.1111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.11111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.1111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.11111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.1111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.11111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('day', 1683, TIMESTAMP '2001-01-31 13:31:00.111111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.1 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.11 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.1111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.11111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.1111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.11111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.1111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.11111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('week', 240, TIMESTAMP '2001-02-03 13:31:00.111111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.1 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.11 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.1111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.11111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.1111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.11111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.1111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.11111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('month', 55, TIMESTAMP '2001-02-10 13:31:00.111111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.1 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.11 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.1111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.11111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.1111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.11111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.1111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.11111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('quarter', 18, TIMESTAMP '2001-03-10 13:31:00.111111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.1 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.11 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.1111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.11111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.1111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.11111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.1111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.1111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.11111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.11111111111 Europe/Warsaw'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_add('year', 4, TIMESTAMP '2001-09-10 13:31:00.111111111111 Europe/Warsaw')")))).matches("TIMESTAMP '2005-09-10 13:31:00.111111111111 Europe/Warsaw'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("date_diff('foo', TIMESTAMP '2001-01-31 19:34:55 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00 Europe/Warsaw')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("'foo' is not a valid TIMESTAMP field");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("date_diff('foo', TIMESTAMP '2001-01-31 19:34:55.111111111111 Europe/Warsaw', TIMESTAMP '2005-09-10 13:31:00.999999999999 Europe/Warsaw')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("'foo' is not a valid TIMESTAMP field");
    }

    @Test
    public void testGreatest() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TIMESTAMP '2002-01-02 03:04:05.321 +07:09'", "TIMESTAMP '2001-01-02 01:04:05.321 +02:09'", "TIMESTAMP '2000-01-02 01:04:05.321 +02:09'")))).matches("TIMESTAMP '2002-01-02 03:04:05.321 +07:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "TIMESTAMP '2001-01-02 03:04:05.321 +07:09'", "TIMESTAMP '2001-01-02 04:04:05.321 +10:09'")))).matches("TIMESTAMP '2001-01-02 03:04:05.321 +07:09'");
    }

    @Test
    public void testLeast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TIMESTAMP '2001-01-02 03:04:05.321 +07:09'", "TIMESTAMP '2001-01-02 01:04:05.321 +02:09'", "TIMESTAMP '2002-01-02 01:04:05.321 +02:09'")))).matches("TIMESTAMP '2001-01-02 03:04:05.321 +07:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "TIMESTAMP '2001-01-02 03:04:05.321 +07:09'", "TIMESTAMP '2001-01-02 01:04:05.321 +02:09'")))).matches("TIMESTAMP '2001-01-02 03:04:05.321 +07:09'");
    }

    @Test
    public void testTimeZoneHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234567890 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345678901 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456789012 +07:09')")))).isEqualTo(7L);
    }

    @Test
    public void testTimeZoneMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234567890 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345678901 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456789012 +07:09')")))).isEqualTo(9L);
    }

    @Test
    public void testLastDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
    }

    @Test
    public void testToUnixTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("1589093396e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("1589093396.1e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("1589093396.12e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("1589093396.123e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("1589093396.1234e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("1589093396.1234498e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("1589093396.123456e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
    }

    @Test
    public void testOrdering() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00 America/New_York', TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00 America/New_York', TIMESTAMP '2020-05-10 02:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00 America/New_York', TIMESTAMP '2020-05-10 03:00:00 America/Los_Angeles' ) t(value)ORDER BY value"))).ordered().matches("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00 America/New_York', TIMESTAMP '2020-05-10 02:00:00 America/New_York', TIMESTAMP '2020-05-10 03:00:00 America/New_York', TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00 America/Los_Angeles' ) t(value)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 02:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 03:00:00.000000 America/Los_Angeles' ) t(value)ORDER BY value"))).ordered().matches("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 02:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 03:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00.000000 America/Los_Angeles' ) t(value)");
    }

    @Test
    public void testJoin() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM (VALUES TIMESTAMP '2020-05-10 04:00:00 America/New_York') t(v) JOIN (VALUES TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles') u(v) USING (v)"))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM (VALUES TIMESTAMP '2020-05-10 04:00:00.000000 America/New_York') t(v) JOIN (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles') u(v) USING (v)"))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testCastInvalidTimestamp() {
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('ABC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: ABC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-00 00:00:00 UTC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-00 00:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-00-01 00:00:00 UTC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-00-01 00:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 25:00:00 UTC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 25:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:61:00 UTC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:61:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:00:61 UTC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:61 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:00:00 ABC' AS TIMESTAMP WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:00 ABC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('ABC' AS TIMESTAMP(12))")::evaluate).hasMessage("Value cannot be cast to timestamp: ABC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-00 00:00:00 UTC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-00 00:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-00-01 00:00:00 UTC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-00-01 00:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 25:00:00 UTC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 25:00:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:61:00 UTC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:61:00 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:00:61 UTC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:61 UTC");
        Assertions.assertThatThrownBy(this.assertions.expression("CAST('2022-01-01 00:00:00 ABC' AS TIMESTAMP(12) WITH TIME ZONE)")::evaluate).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:00 ABC");
    }

    @Test
    public void testExtractTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 Asia/Tokyo')")))).isEqualTo("Asia/Tokyo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 America/New_York')")))).isEqualTo("America/New_York");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 Europe/London')")))).isEqualTo("Europe/London");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 UTC')")))).isEqualTo("UTC");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 +01:00')")))).isEqualTo("+01:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 -08:00')")))).isEqualTo("-08:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '1500-01-01 12:00:00 Europe/London')")))).isEqualTo("Europe/London");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2500-01-01 12:00:00 Asia/Tokyo')")))).isEqualTo("Asia/Tokyo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-02-29 12:00:00 UTC')")))).isEqualTo("UTC");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 +14:00')")))).isEqualTo("+14:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 -12:00')")))).isEqualTo("-12:00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '0001-01-01 00:00:00 UTC')")))).isEqualTo("UTC");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '9999-12-31 23:59:59 UTC')")))).isEqualTo("UTC");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00.123 UTC')")))).isEqualTo("UTC");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00.123456789 UTC')")))).isEqualTo("UTC");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("timezone(TIMESTAMP '2024-13-01 12:00:00 UTC')").evaluate()).hasMessageContaining("is not a valid TIMESTAMP literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 +25:00')").evaluate()).hasMessageContaining("is not a valid TIMESTAMP literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("timezone(TIMESTAMP '2024-01-01 12:00:00 asia/tokyo')").evaluate()).hasMessageContaining("is not a valid TIMESTAMP literal");
    }

    private BiFunction<Session, QueryRunner, Object> timestampWithTimeZone(int precision, int year, int month, int day, int hour, int minute, int second, long picoOfSecond, TimeZoneKey timeZoneKey) {
        return (session, queryRunner) -> {
            ZonedDateTime base = ZonedDateTime.of(year, month, day, hour, minute, second, 0, timeZoneKey.getZoneId());
            long epochMillis = base.toEpochSecond() * 1000L + picoOfSecond / 1000000000L;
            int picosOfMilli = (int)(picoOfSecond % 1000000000L);
            return SqlTimestampWithTimeZone.newInstance((int)precision, (long)epochMillis, (int)picosOfMilli, (TimeZoneKey)timeZoneKey);
        };
    }
}

