/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.window.AbstractTestWindowFunction;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import org.junit.jupiter.api.Test;

public class TestApproxPercentileWindow
extends AbstractTestWindowFunction {
    @Test
    public void testDoubleApproxPercentile() {
        this.assertWindowQuery("approx_percentile(DOUBLE '42', 0.5) over ()", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", 42.0}).row(new Object[]{2, "O", 42.0}).row(new Object[]{3, "F", 42.0}).row(new Object[]{4, "O", 42.0}).row(new Object[]{5, "F", 42.0}).row(new Object[]{6, "F", 42.0}).row(new Object[]{7, "O", 42.0}).row(new Object[]{32, "O", 42.0}).row(new Object[]{33, "F", 42.0}).row(new Object[]{34, "O", 42.0}).build());
    }

    @Test
    public void testLongArrayApproxPercentile() {
        this.assertWindowQuery("approx_percentile(12, array[0.3, 0.7]) over ()", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)}).row(new Object[]{1, "O", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{2, "O", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{3, "F", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{4, "O", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{5, "F", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{6, "F", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{7, "O", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{32, "O", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{33, "F", ImmutableList.of((Object)12L, (Object)12L)}).row(new Object[]{34, "O", ImmutableList.of((Object)12L, (Object)12L)}).build());
    }

    @Test
    public void testDoubleArrayApproxPercentile() {
        this.assertWindowQuery("approx_percentile(DOUBLE '42.3', array[0.5]) over ()", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, new ArrayType((Type)DoubleType.DOUBLE)}).row(new Object[]{1, "O", ImmutableList.of((Object)42.3)}).row(new Object[]{2, "O", ImmutableList.of((Object)42.3)}).row(new Object[]{3, "F", ImmutableList.of((Object)42.3)}).row(new Object[]{4, "O", ImmutableList.of((Object)42.3)}).row(new Object[]{5, "F", ImmutableList.of((Object)42.3)}).row(new Object[]{6, "F", ImmutableList.of((Object)42.3)}).row(new Object[]{7, "O", ImmutableList.of((Object)42.3)}).row(new Object[]{32, "O", ImmutableList.of((Object)42.3)}).row(new Object[]{33, "F", ImmutableList.of((Object)42.3)}).row(new Object[]{34, "O", ImmutableList.of((Object)42.3)}).build());
    }
}

