/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.server.ServerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestServerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ServerConfig)ConfigAssertions.recordDefaults(ServerConfig.class)).setCoordinator(true).setConcurrentStartup(false).setIncludeExceptionInResponse(true).setGracePeriod(new Duration(2.0, TimeUnit.MINUTES)).setQueryResultsCompressionEnabled(true).setQueryInfoUrlTemplate(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"coordinator", (Object)"false").put((Object)"experimental.concurrent-startup", (Object)"true").put((Object)"http.include-exception-in-response", (Object)"false").put((Object)"shutdown.grace-period", (Object)"5m").put((Object)"query-results.compression-enabled", (Object)"false").put((Object)"query.info-url-template", (Object)"https://example.com/query/${QUERY_ID}").buildOrThrow();
        ServerConfig expected = new ServerConfig().setCoordinator(false).setConcurrentStartup(true).setIncludeExceptionInResponse(false).setGracePeriod(new Duration(5.0, TimeUnit.MINUTES)).setQueryResultsCompressionEnabled(false).setQueryInfoUrlTemplate("https://example.com/query/${QUERY_ID}");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

