/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.server.SliceSerialization;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSliceSerialization {
    private ObjectMapperProvider provider;

    @BeforeAll
    public void setup() {
        this.provider = new ObjectMapperProvider();
        this.provider.setJsonSerializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerialization.SliceSerializer()));
        this.provider.setJsonDeserializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerialization.SliceDeserializer()));
    }

    @AfterAll
    public void teardown() {
        this.provider = null;
    }

    @Test
    public void testRoundTrip() throws JsonProcessingException {
        this.testRoundTrip(new byte[0]);
        this.testRoundTrip(new byte[]{1});
        this.testRoundTrip(new byte[]{1, 2});
        this.testRoundTrip(new byte[]{1, 2, 3});
        byte[] randomBytes = new byte[1022];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.testRoundTrip(randomBytes);
    }

    private void testRoundTrip(byte[] bytes) throws JsonProcessingException {
        this.testRoundTrip(Slices.wrappedBuffer((byte[])bytes));
        Slice slice = Slices.wrappedBuffer((byte[])new byte[bytes.length + 3], (int)2, (int)bytes.length);
        slice.setBytes(0, bytes);
        this.testRoundTrip(slice);
        slice = Slices.allocate((int)bytes.length);
        slice.setBytes(0, bytes);
        this.testRoundTrip(slice);
    }

    private void testRoundTrip(Slice slice) throws JsonProcessingException {
        ObjectMapper objectMapper = this.provider.get();
        Container expected = new Container(slice);
        String json = objectMapper.writeValueAsString((Object)expected);
        Container actual = (Container)objectMapper.readValue(json, Container.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    public static class Container {
        private final Slice value;

        @JsonCreator
        public Container(@JsonProperty(value="value") Slice value) {
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @JsonProperty
        public Slice getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Container container = (Container)o;
            return Objects.equals(this.value, container.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

