/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.secrets.SecretsResolver;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.HeaderAuthenticator;
import io.trino.spi.security.HeaderAuthenticatorFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHeaderAuthenticatorManager {
    @Test
    public void testMultipleConfigFiles() throws Exception {
        Path config1 = Files.createTempFile("headerConfig", "1", new FileAttribute[0]);
        Path config2 = Files.createTempFile("headerConfig", "2", new FileAttribute[0]);
        Files.write(config1, (Iterable<? extends CharSequence>)ImmutableList.of((Object)"header-authenticator.name=type1"), new OpenOption[0]);
        Files.write(config2, (Iterable<? extends CharSequence>)ImmutableList.of((Object)"header-authenticator.name=type2"), new OpenOption[0]);
        String trustedHeaderOne = "x-forwarded-client-cert";
        String trustedHeaderTwo = "forwarded-client-cert";
        ImmutableMap validRequestOne = ImmutableMap.of((Object)trustedHeaderOne, (Object)ImmutableList.of((Object)"foo", (Object)"bar"));
        ImmutableMap validRequestTwo = ImmutableMap.of((Object)trustedHeaderTwo, (Object)ImmutableList.of((Object)"cat", (Object)"dog"));
        ImmutableMap invalidRequestOne = ImmutableMap.of((Object)"try-hard-authn", (Object)ImmutableList.of((Object)"foo", (Object)"bar"));
        HeaderAuthenticatorManager manager = new HeaderAuthenticatorManager(new HeaderAuthenticatorConfig().setHeaderAuthenticatorFiles((List)ImmutableList.of((Object)config1.toAbsolutePath().toString(), (Object)config2.toAbsolutePath().toString())), new SecretsResolver((Map)ImmutableMap.of()));
        manager.setRequired();
        manager.addHeaderAuthenticatorFactory((HeaderAuthenticatorFactory)new TestingHeaderAuthenticatorFactory("type1", trustedHeaderOne));
        manager.addHeaderAuthenticatorFactory((HeaderAuthenticatorFactory)new TestingHeaderAuthenticatorFactory("type2", trustedHeaderTwo));
        manager.loadHeaderAuthenticator();
        List authenticators = manager.getAuthenticators();
        Assertions.assertThat((boolean)this.login(authenticators, arg_0 -> ((ImmutableMap)validRequestOne).get(arg_0))).isTrue();
        Assertions.assertThat((boolean)this.login(authenticators, arg_0 -> ((ImmutableMap)validRequestTwo).get(arg_0))).isTrue();
        Assertions.assertThat((boolean)this.login(authenticators, arg_0 -> ((ImmutableMap)invalidRequestOne).get(arg_0))).isFalse();
    }

    private boolean login(List<HeaderAuthenticator> authenticators, HeaderAuthenticator.Headers headers) {
        return authenticators.stream().anyMatch(authenticator -> {
            try {
                authenticator.createAuthenticatedPrincipal(headers);
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        });
    }

    private static class TestingHeaderAuthenticatorFactory
    implements HeaderAuthenticatorFactory {
        private final String header;
        private final String name;

        TestingHeaderAuthenticatorFactory(String name, String header) {
            this.header = Objects.requireNonNull(header, "header is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public String getName() {
            return this.name;
        }

        public HeaderAuthenticator create(Map<String, String> config) {
            return headers -> (Principal)Optional.ofNullable(headers.getHeader(this.header)).map(values -> new BasicPrincipal((String)values.get(0))).orElseThrow(() -> new AccessDeniedException("You shall not pass!"));
        }
    }
}

