/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.server.security.KerberosConfig;
import io.trino.server.security.KerberosNameType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestKerberosConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KerberosConfig)ConfigAssertions.recordDefaults(KerberosConfig.class)).setKerberosConfig(null).setServiceName(null).setKeytab(null).setPrincipalHostname(null).setNameType(KerberosNameType.HOSTBASED_SERVICE).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path krbConfigFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path keytabFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http.authentication.krb5.config", (Object)krbConfigFile.toString()).put((Object)"http-server.authentication.krb5.service-name", (Object)"airlift").put((Object)"http-server.authentication.krb5.keytab", (Object)keytabFile.toString()).put((Object)"http-server.authentication.krb5.principal-hostname", (Object)"test.example.com").put((Object)"http-server.authentication.krb5.name-type", (Object)"USER_NAME").put((Object)"http-server.authentication.krb5.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.krb5.user-mapping.file", (Object)userMappingFile.toString()).buildOrThrow();
        KerberosConfig expected = new KerberosConfig().setKerberosConfig(krbConfigFile.toFile()).setServiceName("airlift").setKeytab(keytabFile.toFile()).setPrincipalHostname("test.example.com").setNameType(KerberosNameType.USER_NAME).setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

