/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.collect.ImmutableMap;
import io.trino.server.ui.MultipartUiCookie;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;

class TestMultipartUiCookie {
    private static final String COOKIE_NAME = "__UI_Cookie";
    private static final MultipartUiCookie COOKIE = new MultipartUiCookie("__UI_Cookie", "/location");

    TestMultipartUiCookie() {
    }

    @Test
    public void testCookieNames() {
        Assertions.assertThat((String)COOKIE.cookieName(0)).isEqualTo(COOKIE_NAME);
        Assertions.assertThat((String)COOKIE.cookieName(1)).isEqualTo("__UI_Cookie_1");
        Assertions.assertThat((String)COOKIE.cookieName(500)).isEqualTo("__UI_Cookie_500");
    }

    @Test
    public void testShortValueRoundTrip() {
        String longToken = "123456789".repeat(100);
        Object[] newCookies = COOKIE.create(longToken, Instant.EPOCH, true);
        Assertions.assertThat((Object[])newCookies).hasSize(1);
        Assertions.assertThat((Object[])newCookies).extracting(Cookie::getName).hasSameElementsAs(List.of(COOKIE.cookieName(0)));
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies((NewCookie[])newCookies))).contains((Object)longToken);
        Object[] deleteCookies = COOKIE.delete(TestMultipartUiCookie.cookies((NewCookie[])newCookies), true);
        Assertions.assertThat((Object[])deleteCookies).hasSize(1);
        Assertions.assertThat((Object[])deleteCookies).extracting(Cookie::getName).hasSameElementsAs(List.of(COOKIE.cookieName(0)));
    }

    @Test
    public void testLongValueRoundTrip() {
        String longToken = "123456789".repeat(1000);
        Object[] newCookies = COOKIE.create(longToken, Instant.EPOCH, true);
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])newCookies).hasSize(3)).allMatch(NewCookie::isSecure)).allMatch(NewCookie::isHttpOnly)).allMatch(cookie -> cookie.getMaxAge() == -1)).allMatch(cookie -> cookie.getExpiry().equals(Date.from(Instant.EPOCH)))).allMatch(cookie -> cookie.getName().length() + cookie.getValue().length() <= 4096);
        Assertions.assertThat((Object[])newCookies).extracting(Cookie::getName).hasSameElementsAs(List.of(COOKIE.cookieName(0), COOKIE.cookieName(1), COOKIE.cookieName(2)));
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies((NewCookie[])newCookies))).contains((Object)longToken);
        Object[] deleteCookies = COOKIE.delete(TestMultipartUiCookie.cookies((NewCookie[])newCookies), false);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])deleteCookies).hasSize(3)).allMatch(cookie -> !cookie.isSecure())).extracting(Cookie::getName).hasSameElementsAs(List.of(COOKIE.cookieName(0), COOKIE.cookieName(1), COOKIE.cookieName(2)));
    }

    @Test
    public void testMultipartValueRead() {
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(1, "b")))).contains((Object)"ab");
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(1, "b"), TestMultipartUiCookie.cookie(2, "c")))).contains((Object)"abc");
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(1, "b"), TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(2, "c")))).contains((Object)"abc");
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(2, "c"), TestMultipartUiCookie.cookie(1, "b"), TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.collidingCookie(0, "d")))).contains((Object)"abc");
    }

    @Test
    public void testNonContinuousValueRead() {
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(2, "b")))).isEmpty();
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(1, "b"), TestMultipartUiCookie.cookie(3, "a")))).isEmpty();
        Assertions.assertThat((Optional)COOKIE.read(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(1, "a")))).isEmpty();
    }

    @Test
    public void testDelete() {
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])COOKIE.delete(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(2, "b"), TestMultipartUiCookie.collidingCookie(3, "d")), true)).hasSize(2)).allMatch(cookie -> cookie.getMaxAge() == 0)).allMatch(cookie -> cookie.getValue().equals("delete"))).allMatch(NewCookie::isSecure)).allMatch(NewCookie::isHttpOnly);
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])COOKIE.delete(TestMultipartUiCookie.cookies(TestMultipartUiCookie.cookie(0, "a"), TestMultipartUiCookie.cookie(2, "b"), TestMultipartUiCookie.cookie("some-other-cookie", "some-other-value")), false)).hasSize(2)).allMatch(cookie -> cookie.getName().startsWith(COOKIE_NAME))).allMatch(cookie -> cookie.getMaxAge() == 0)).allMatch(cookie -> cookie.getValue().equals("delete"))).allMatch(cookie -> !cookie.isSecure())).allMatch(NewCookie::isHttpOnly);
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])COOKIE.delete(TestMultipartUiCookie.cookies(new NewCookie[0]), false)).hasSize(1)).allMatch(cookie -> cookie.getName().startsWith(COOKIE_NAME))).allMatch(cookie -> cookie.getMaxAge() == 0)).allMatch(cookie -> cookie.getValue().equals("delete"))).allMatch(cookie -> !cookie.isSecure())).allMatch(NewCookie::isHttpOnly);
    }

    private static Map<String, Cookie> cookies(NewCookie ... cookies) {
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)cookies.length);
        for (NewCookie cookie : cookies) {
            result.put((Object)cookie.getName(), (Object)cookie);
        }
        return result.buildOrThrow();
    }

    private static NewCookie cookie(int index, String value) {
        return TestMultipartUiCookie.cookie(COOKIE.cookieName(index), value);
    }

    private static NewCookie collidingCookie(int index, String value) {
        return TestMultipartUiCookie.cookie(COOKIE.cookieName(index) + "-ignored", value);
    }

    private static NewCookie cookie(String name, String value) {
        return ((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(name).value(value)).build();
    }
}

