/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.trino.sql.ir.Expression;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;

public final class ExpressionTestUtils {
    private ExpressionTestUtils() {
    }

    public static void assertExpressionEquals(Expression actual, Expression expected) {
        ExpressionTestUtils.assertExpressionEquals(actual, expected, new SymbolAliases());
    }

    public static void assertExpressionEquals(Expression actual, Expression expected, SymbolAliases symbolAliases) {
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        if (!((Boolean)verifier.process(actual, expected)).booleanValue()) {
            ExpressionTestUtils.failNotEqual(actual, expected, null);
        }
    }

    private static void failNotEqual(Object actual, Object expected, String message) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        throw new AssertionError((Object)((String)formatted + " expected [" + String.valueOf(expected) + "] but found [" + String.valueOf(actual) + "]"));
    }
}

