/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.execution.Column;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Output;
import io.trino.sql.analyzer.OutputColumn;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOutput {
    private static final JsonCodec<Output> codec = JsonCodec.jsonCodec(Output.class);

    @Test
    public void testRoundTrip() {
        Output expected = new Output("connectorId", new CatalogHandle.CatalogVersion("default"), "schema", "table", Optional.of(ImmutableList.of((Object)new OutputColumn(new Column("column", "type"), (Set)ImmutableSet.of((Object)new Analysis.SourceColumn(QualifiedObjectName.valueOf((String)"catalog.schema.table"), "column"))))));
        String json = codec.toJson((Object)expected);
        Output actual = (Output)codec.fromJson(json);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testRoundWithComplexIdentifiers() {
        Output expected = new Output("catalog.M\u00f3j", new CatalogHandle.CatalogVersion("default"), "\u015bci.e-Ma", "ta.b-Elk\u0105 go", Optional.of(ImmutableList.of((Object)new OutputColumn(new Column("ko.LU-mie\u0144ka", "type"), (Set)ImmutableSet.of((Object)new Analysis.SourceColumn(new QualifiedObjectName("catalog.tw\u00f3j", "schema.\u015bciema", "tabel.tabelk\u00f3wna"), "co-lumn.s\u0142odziak\""))))));
        String json = codec.toJson((Object)expected);
        Output actual = (Output)codec.fromJson(json);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

