/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionFormatter;
import io.trino.sql.ir.Reference;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionFormatter {
    @Test
    public void testReference() {
        this.assertFormattedExpression((Expression)new Reference((Type)BigintType.BIGINT, "abc"), "abc");
        this.assertFormattedExpression((Expression)new Reference((Type)BigintType.BIGINT, "with a space"), "\"with a space\"");
        this.assertFormattedExpression((Expression)new Reference((Type)BigintType.BIGINT, "with \" quote, $ dollar and ' apostrophe"), "\"with \"\" quote, $ dollar and ' apostrophe\"");
    }

    private void assertFormattedExpression(Expression expression, String expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)ExpressionFormatter.formatExpression((Expression)expression)).as("formatted expression", new Object[0])).isEqualTo(expected);
    }
}

