/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.DistributeComparisonOverCase;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestDistributeComparisonOverCase {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "y"))), (Expression)new Reference((Type)BigintType.BIGINT, "z")), (Expression)new Reference((Type)BigintType.BIGINT, "m")))).describedAs("case(...) < reference", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "m"))), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "m")))), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "z"), (Expression)new Reference((Type)BigintType.BIGINT, "m")))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "y"))), (Expression)new Reference((Type)BigintType.BIGINT, "z")), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("case(...) < constant", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "z"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "m"), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "y"))), (Expression)new Reference((Type)BigintType.BIGINT, "z"))))).describedAs("reference < case(...)", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "m"))), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Reference((Type)BigintType.BIGINT, "m")))), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "z"), (Expression)new Reference((Type)BigintType.BIGINT, "m")))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "x")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "y"))), (Expression)new Reference((Type)BigintType.BIGINT, "z"))))).describedAs("constant < case(...)", new Object[0])).isEqualTo(Optional.of(new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "z"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new DistributeComparisonOverCase().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

