/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.operator.table.json.JsonTableColumn;
import io.trino.operator.table.json.JsonTableOrdinalityColumn;
import io.trino.operator.table.json.JsonTablePlanCross;
import io.trino.operator.table.json.JsonTablePlanLeaf;
import io.trino.operator.table.json.JsonTablePlanNode;
import io.trino.operator.table.json.JsonTablePlanSingle;
import io.trino.operator.table.json.JsonTablePlanUnion;
import io.trino.operator.table.json.JsonTableQueryColumn;
import io.trino.operator.table.json.JsonTableValueColumn;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class JsonTablePlanComparator {
    private JsonTablePlanComparator() {
    }

    public static Comparator<JsonTablePlanNode> planComparator() {
        return (actual, expected) -> {
            Objects.requireNonNull(actual, "actual is null");
            Objects.requireNonNull(expected, "expected is null");
            return JsonTablePlanComparator.compare(actual, expected) ? 0 : -1;
        };
    }

    private static boolean compare(JsonTablePlanNode left, JsonTablePlanNode right) {
        List rightSiblings;
        List leftSiblings;
        if (left == right) {
            return true;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left instanceof JsonTablePlanLeaf) {
            JsonTablePlanLeaf leftPlan = (JsonTablePlanLeaf)left;
            JsonTablePlanLeaf rightPlan = (JsonTablePlanLeaf)right;
            return leftPlan.path().equals((Object)rightPlan.path()) && JsonTablePlanComparator.compareColumns(leftPlan.columns(), rightPlan.columns());
        }
        if (left instanceof JsonTablePlanSingle) {
            JsonTablePlanSingle leftPlan = (JsonTablePlanSingle)left;
            JsonTablePlanSingle rightPlan = (JsonTablePlanSingle)right;
            return leftPlan.path().equals((Object)rightPlan.path()) && JsonTablePlanComparator.compareColumns(leftPlan.columns(), rightPlan.columns()) && leftPlan.outer() == rightPlan.outer() && JsonTablePlanComparator.compare(leftPlan.child(), rightPlan.child());
        }
        if (left instanceof JsonTablePlanCross) {
            JsonTablePlanCross leftPlan = (JsonTablePlanCross)left;
            leftSiblings = leftPlan.siblings();
            rightSiblings = ((JsonTablePlanCross)right).siblings();
        } else {
            leftSiblings = ((JsonTablePlanUnion)left).siblings();
            rightSiblings = ((JsonTablePlanUnion)right).siblings();
        }
        if (leftSiblings.size() != rightSiblings.size()) {
            return false;
        }
        for (int i = 0; i < leftSiblings.size(); ++i) {
            if (JsonTablePlanComparator.compare((JsonTablePlanNode)leftSiblings.get(i), (JsonTablePlanNode)rightSiblings.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareColumns(List<JsonTableColumn> leftColumns, List<JsonTableColumn> rightColumns) {
        if (leftColumns.size() != rightColumns.size()) {
            return false;
        }
        for (int i = 0; i < leftColumns.size(); ++i) {
            if (JsonTablePlanComparator.compareColumn(leftColumns.get(i), rightColumns.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareColumn(JsonTableColumn left, JsonTableColumn right) {
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left instanceof JsonTableOrdinalityColumn) {
            JsonTableOrdinalityColumn leftColumn = (JsonTableOrdinalityColumn)left;
            return leftColumn.outputIndex() == ((JsonTableOrdinalityColumn)right).outputIndex();
        }
        if (left instanceof JsonTableQueryColumn) {
            JsonTableQueryColumn leftColumn = (JsonTableQueryColumn)left;
            JsonTableQueryColumn rightColumn = (JsonTableQueryColumn)right;
            return leftColumn.outputIndex() == rightColumn.outputIndex() && leftColumn.function().equals((Object)rightColumn.function()) && leftColumn.path().equals((Object)rightColumn.path()) && leftColumn.wrapperBehavior() == rightColumn.wrapperBehavior() && leftColumn.emptyBehavior() == rightColumn.emptyBehavior() && leftColumn.errorBehavior() == rightColumn.errorBehavior();
        }
        JsonTableValueColumn leftColumn = (JsonTableValueColumn)left;
        JsonTableValueColumn rightColumn = (JsonTableValueColumn)right;
        return leftColumn.outputIndex() == rightColumn.outputIndex() && leftColumn.function().equals((Object)rightColumn.function()) && leftColumn.path().equals((Object)rightColumn.path()) && leftColumn.emptyBehavior() == rightColumn.emptyBehavior() && leftColumn.emptyDefaultInput() == rightColumn.emptyDefaultInput() && leftColumn.errorBehavior() == rightColumn.errorBehavior() && leftColumn.errorDefaultInput() == rightColumn.errorDefaultInput();
    }
}

