/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.operator.DeleteAndInsertMergeProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeleteAndInsertMergeProcessor {
    @Test
    public void testSimpleDeletedRowMerge() {
        DeleteAndInsertMergeProcessor processor = this.makeMergeProcessor();
        Block[] rowIdBlocks = new Block[]{this.makeLongArrayBlock(1L, 1L), this.makeLongArrayBlock(1L, 0L), this.makeIntArrayBlock(0x20000000, 0x20000000)};
        Block[] mergeCaseBlocks = new Block[]{this.makeVarcharArrayBlock(null, "Dave"), new IntArrayBlock(2, Optional.of(new boolean[]{true, false}), new int[]{0, 11}), this.makeVarcharArrayBlock(null, "Devon"), new ByteArrayBlock(2, Optional.of(new boolean[]{true, false}), new byte[]{0, 1}), new ByteArrayBlock(2, Optional.of(new boolean[]{true, false}), new byte[]{0, 2}), new IntArrayBlock(2, Optional.of(new boolean[]{true, false}), new int[]{0, 0})};
        Page inputPage = new Page(new Block[]{RowBlock.fromNotNullSuppressedFieldBlocks((int)2, Optional.empty(), (Block[])rowIdBlocks), RowBlock.fromNotNullSuppressedFieldBlocks((int)2, Optional.of(new boolean[]{true, false}), (Block[])mergeCaseBlocks)});
        Page outputPage = processor.transformPage(inputPage);
        Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(1);
        Assertions.assertThat((int)TinyintType.TINYINT.getByte(outputPage.getBlock(3), 0)).isEqualTo(2);
        SqlRow rowIdRow = ((RowBlock)outputPage.getBlock(4)).getRow(0);
        Assertions.assertThat((long)BigintType.BIGINT.getLong(rowIdRow.getRawFieldBlock(1), rowIdRow.getRawIndex())).isEqualTo(0L);
    }

    @Test
    public void testUpdateAndDeletedMerge() {
        DeleteAndInsertMergeProcessor processor = this.makeMergeProcessor();
        boolean[] rowIdNulls = new boolean[]{false, true, false, false, false};
        Page inputPage = TestDeleteAndInsertMergeProcessor.makePageFromBlocks(5, Optional.of(rowIdNulls), new Block[]{new LongArrayBlock(5, Optional.of(rowIdNulls), new long[]{2L, 0L, 1L, 2L, 2L}), new LongArrayBlock(5, Optional.of(rowIdNulls), new long[]{0L, 0L, 3L, 1L, 2L}), new IntArrayBlock(5, Optional.of(rowIdNulls), new int[]{0x20000000, 0, 0x20000000, 0x20000000, 0x20000000})}, new Block[]{this.makeVarcharArrayBlock("Aaron", "Carol", "Dave", "Dave", "Ed"), this.makeIntArrayBlock(17, 9, 11, 22, 14), this.makeVarcharArrayBlock("Arches/Arches", "Centreville", "Devon", "Darbyshire/Darbyshire", "Etherville/Etherville"), this.makeByteArrayBlock(1, 0, 1, 1, 1), this.makeByteArrayBlock(3, 1, 2, 3, 3), this.makeIntArrayBlock(0, 1, 2, 0, 0)});
        Page outputPage = processor.transformPage(inputPage);
        Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(8);
        RowBlock rowIdBlock = (RowBlock)outputPage.getBlock(4);
        Assertions.assertThat((int)rowIdBlock.getPositionCount()).isEqualTo(8);
        Assertions.assertThat((String)this.getString(outputPage.getBlock(2), 1)).isEqualTo("Arches/Arches");
    }

    @Test
    public void testAnotherMergeCase() {
        DeleteAndInsertMergeProcessor processor = this.makeMergeProcessor();
        boolean[] rowIdNulls = new boolean[]{false, true, false, false, false};
        Page inputPage = TestDeleteAndInsertMergeProcessor.makePageFromBlocks(5, Optional.of(rowIdNulls), new Block[]{new LongArrayBlock(5, Optional.of(rowIdNulls), new long[]{2L, 0L, 1L, 2L, 2L}), new LongArrayBlock(5, Optional.of(rowIdNulls), new long[]{0L, 0L, 3L, 1L, 2L}), new IntArrayBlock(5, Optional.of(rowIdNulls), new int[]{0x20000000, 0, 0x20000000, 0x20000000, 0x20000000})}, new Block[]{this.makeVarcharArrayBlock("Aaron", "Carol", "Dave", "Dave", "Ed"), this.makeIntArrayBlock(17, 9, 11, 22, 14), this.makeVarcharArrayBlock("Arches/Arches", "Centreville", "Devon", "Darbyshire/Darbyshire", "Etherville/Etherville"), this.makeByteArrayBlock(1, 0, 1, 1, 0), this.makeByteArrayBlock(3, 1, 2, 3, 3), this.makeIntArrayBlock(0, -1, 1, 0, 0)});
        Page outputPage = processor.transformPage(inputPage);
        Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(8);
        RowBlock rowIdBlock = (RowBlock)outputPage.getBlock(4);
        Assertions.assertThat((int)rowIdBlock.getPositionCount()).isEqualTo(8);
        Assertions.assertThat((String)this.getString(outputPage.getBlock(2), 1)).isEqualTo("Arches/Arches");
    }

    private static Page makePageFromBlocks(int positionCount, Optional<boolean[]> rowIdNulls, Block[] rowIdBlocks, Block[] mergeCaseBlocks) {
        Block[] pageBlocks = new Block[]{RowBlock.fromNotNullSuppressedFieldBlocks((int)positionCount, rowIdNulls, (Block[])rowIdBlocks), RowBlock.fromFieldBlocks((int)positionCount, (Block[])mergeCaseBlocks)};
        return new Page(pageBlocks);
    }

    private DeleteAndInsertMergeProcessor makeMergeProcessor() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR);
        RowType rowIdType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)IntegerType.INTEGER));
        return new DeleteAndInsertMergeProcessor((List)types, (Type)rowIdType, 0, 1, (List)ImmutableList.of(), (List)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    private String getString(Block block, int position) {
        return VarbinaryType.VARBINARY.getSlice(block, position).toString(Charset.defaultCharset());
    }

    private LongArrayBlock makeLongArrayBlock(long ... elements) {
        return new LongArrayBlock(elements.length, Optional.empty(), elements);
    }

    private IntArrayBlock makeIntArrayBlock(int ... elements) {
        return new IntArrayBlock(elements.length, Optional.empty(), elements);
    }

    private ByteArrayBlock makeByteArrayBlock(int ... elements) {
        byte[] bytes = new byte[elements.length];
        for (int index = 0; index < elements.length; ++index) {
            bytes[index] = (byte)elements[index];
        }
        return new ByteArrayBlock(elements.length, Optional.empty(), bytes);
    }

    private Block makeVarcharArrayBlock(String ... elements) {
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new PageBuilderStatus().createBlockBuilderStatus(), elements.length);
        for (String element : elements) {
            if (element == null) {
                builder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeSlice((BlockBuilder)builder, Slices.utf8Slice((String)element));
        }
        return builder.build();
    }
}

