/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.PartialTranslator;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartialTranslator {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setTransactionId(TransactionId.create()).build();

    @Test
    public void testPartialTranslator() {
        Reference rowSymbolReference = new Reference((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, IntegerType.INTEGER}), "row_symbol_1");
        FieldReference dereferenceExpression1 = new FieldReference((Expression)rowSymbolReference, 0);
        FieldReference dereferenceExpression2 = new FieldReference((Expression)rowSymbolReference, 1);
        Constant stringLiteral = new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abcd"));
        Reference symbolReference1 = new Reference((Type)IntegerType.INTEGER, "double_symbol_1");
        this.assertFullTranslation((Expression)symbolReference1);
        this.assertFullTranslation((Expression)dereferenceExpression1);
        this.assertFullTranslation((Expression)stringLiteral);
        this.assertFullTranslation((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)symbolReference1, (Object)dereferenceExpression1)));
        Call functionCallExpression = new Call(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().resolveBuiltinFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)stringLiteral, (Object)new Cast((Expression)dereferenceExpression2, (Type)VarcharType.VARCHAR)));
        this.assertFullTranslation((Expression)functionCallExpression);
    }

    private void assertFullTranslation(Expression expression) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION);
        Assertions.assertThat((Object)((NodeRef)Iterables.getOnlyElement(translation.keySet()))).isEqualTo((Object)NodeRef.of((Expression)expression));
        Assertions.assertThat((Object)((ConnectorExpression)Iterables.getOnlyElement(translation.values()))).isEqualTo(ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression).get());
    }
}

