/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.SortExpressionContext;
import io.trino.sql.planner.SortExpressionExtractor;
import io.trino.sql.planner.Symbol;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSortExpressionExtractor {
    private static final Set<Symbol> BUILD_SYMBOLS = ImmutableSet.of((Object)new Symbol((Type)BigintType.BIGINT, "b1"), (Object)new Symbol((Type)BigintType.BIGINT, "b2"));
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    @Test
    public void testGetSortExpression() {
        this.assertGetSortExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b1")), "b1");
        this.assertGetSortExpression((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), "b2");
        this.assertGetSortExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), "b2");
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Call(RANDOM, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p1")))), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")))), "b1", new Expression[]{new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1"))});
        this.assertNoSortExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p1"), (Object)new Reference((Type)BigintType.BIGINT, "b2")))));
        this.assertNoSortExpression((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")))));
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")))), "b1");
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")))), "b1", new Expression[]{new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1"))});
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p1"), (Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p2")))), "b2", new Expression[]{new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p1"), (Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))), new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Reference((Type)BigintType.BIGINT, "p2"))});
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Between((Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "b2")), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p2"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L)))))), "b2", new Expression[]{new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b2")), new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "p2"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))});
        this.assertGetSortExpression((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "p2"), (Expression)new Reference((Type)BigintType.BIGINT, "b1")), "b1", new Expression[]{new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b1"))});
        this.assertGetSortExpression((Expression)new Between((Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "p2")), "b1", new Expression[]{new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p2"))});
        this.assertGetSortExpression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), (Object)new Between((Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "b2")))), "b1", new Expression[]{new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b1"), (Expression)new Reference((Type)BigintType.BIGINT, "p1")), new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "p1"), (Expression)new Reference((Type)BigintType.BIGINT, "b1"))});
    }

    private void assertNoSortExpression(Expression expression) {
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_SYMBOLS, (Expression)expression);
        Assertions.assertThat((Optional)actual).isEqualTo(Optional.empty());
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol) {
        this.assertGetSortExpression(expression, expectedSymbol, IrUtils.extractConjuncts((Expression)expression));
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, Expression ... searchExpressions) {
        this.assertGetSortExpression(expression, expectedSymbol, Arrays.asList(searchExpressions));
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, List<Expression> searchExpressions) {
        Optional<SortExpressionContext> expected = Optional.of(new SortExpressionContext((Expression)new Reference((Type)BigintType.BIGINT, expectedSymbol), searchExpressions));
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_SYMBOLS, (Expression)expression);
        Assertions.assertThat((Optional)actual).isEqualTo(expected);
    }
}

