/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanMatchingVisitor;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.AdaptivePlanNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.Objects;

public class AdaptivePlanMatcher
implements Matcher {
    PlanMatchPattern initialPlan;

    public AdaptivePlanMatcher(PlanMatchPattern initialPlan) {
        this.initialPlan = Objects.requireNonNull(initialPlan, "initialPlanPattern is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof AdaptivePlanNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider statsProvider, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        AdaptivePlanNode adaptivePlanNode = (AdaptivePlanNode)node;
        return (MatchResult)adaptivePlanNode.getInitialPlan().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, Lookup.noLookup()), (Object)this.initialPlan);
    }

    public String toString() {
        return "AdaptivePlanMatcher\ninitialPlan: \n" + String.valueOf(this.initialPlan);
    }
}

