/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SpatialJoinMatcher
implements Matcher {
    private final SpatialJoinNode.Type type;
    private final Expression filter;
    private final Optional<String> kdbTree;
    private final Optional<List<String>> outputSymbols;

    public SpatialJoinMatcher(SpatialJoinNode.Type type, Expression filter, Optional<String> kdbTree, Optional<List<String>> outputSymbols) {
        this.type = type;
        this.filter = Objects.requireNonNull(filter, "filter cannot be null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree cannot be null");
        this.outputSymbols = Objects.requireNonNull(outputSymbols, "outputSymbols is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof SpatialJoinNode)) {
            return false;
        }
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        return joinNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        if (!((Boolean)new ExpressionVerifier(symbolAliases).process(joinNode.getFilter(), this.filter)).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!joinNode.getKdbTree().equals(this.kdbTree)) {
            return MatchResult.NO_MATCH;
        }
        if (this.outputSymbols.isPresent()) {
            if (this.outputSymbols.get().size() != joinNode.getOutputSymbols().size()) {
                return MatchResult.NO_MATCH;
            }
            if (!((ImmutableList)this.outputSymbols.get().stream().map(symbolAliases::get).map(Symbol::from).collect(ImmutableList.toImmutableList())).equals((Object)joinNode.getOutputSymbols())) {
                return MatchResult.NO_MATCH;
            }
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).toString();
    }
}

