/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UnnestedSymbolMatcher
implements RvalueMatcher {
    private final String symbol;
    private final int index;

    public UnnestedSymbolMatcher(String symbol, int index) {
        this.symbol = Objects.requireNonNull(symbol, "symbol is null");
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index cannot be negative");
        this.index = index;
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof UnnestNode)) {
            return Optional.empty();
        }
        UnnestNode unnestNode = (UnnestNode)node;
        Symbol unnestSymbol = Symbol.from((Expression)symbolAliases.get(this.symbol));
        List matches = (List)unnestNode.getMappings().stream().filter(mapping -> mapping.getInput().equals((Object)unnestSymbol)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((matches.size() < 2 ? 1 : 0) != 0, (Object)"alias matching not supported for repeated unnest symbols");
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        UnnestNode.Mapping mapping2 = (UnnestNode.Mapping)Iterables.getOnlyElement((Iterable)matches);
        if (this.index >= mapping2.getOutputs().size()) {
            return Optional.empty();
        }
        return Optional.of((Symbol)mapping2.getOutputs().get(this.index));
    }

    public String getSymbol() {
        return this.symbol;
    }
}

