/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Joiner;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.WindowFunction;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Objects;

final class WindowFunctionProvider
implements ExpectedValueProvider<WindowFunction> {
    private final String name;
    private final WindowNode.Frame frame;
    private final List<PlanTestSymbol> args;

    public WindowFunctionProvider(String name, WindowNode.Frame frame, List<PlanTestSymbol> args) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
        this.args = Objects.requireNonNull(args, "args is null");
    }

    public String toString() {
        return "%s(%s) %s".formatted(this.name, Joiner.on((String)", ").join(this.args), this.frame);
    }

    @Override
    public WindowFunction getExpectedValue(SymbolAliases aliases) {
        return new WindowFunction(this.name, this.frame, PlanMatchPattern.toSymbolReferences(this.args, aliases));
    }
}

