/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.ArraySortAfterArrayDistinct;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.FunctionType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestArraySortAfterArrayDistinct
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction SORT = FUNCTIONS.resolveFunction("array_sort", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)VarcharType.VARCHAR)}));
    private static final ResolvedFunction SORT_WITH_LAMBDA = FUNCTIONS.resolveFunction("array_sort", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)VarcharType.VARCHAR), new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), (Type)IntegerType.INTEGER)}));
    private static final ResolvedFunction DISTINCT = FUNCTIONS.resolveFunction("array_distinct", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)VarcharType.VARCHAR)}));

    public TestArraySortAfterArrayDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void testArrayDistinctAfterArraySort() {
        this.test((Expression)new Call(DISTINCT, (List)ImmutableList.of((Object)new Call(SORT, (List)ImmutableList.of((Object)new Array((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))))))), (Expression)new Call(SORT, (List)ImmutableList.of((Object)new Call(DISTINCT, (List)ImmutableList.of((Object)new Array((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))))))));
    }

    @Test
    public void testArrayDistinctAfterArraySortWithLambda() {
        this.test((Expression)new Call(DISTINCT, (List)ImmutableList.of((Object)new Call(SORT_WITH_LAMBDA, (List)ImmutableList.of((Object)new Array((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)VarcharType.VARCHAR, "a"), (Object)new Symbol((Type)VarcharType.VARCHAR, "b")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))))), (Expression)new Call(SORT_WITH_LAMBDA, (List)ImmutableList.of((Object)new Call(DISTINCT, (List)ImmutableList.of((Object)new Array((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))))), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)VarcharType.VARCHAR, "a"), (Object)new Symbol((Type)VarcharType.VARCHAR, "b")), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))));
    }

    private void test(Expression original, Expression rewritten) {
        this.tester().assertThat(new ArraySortAfterArrayDistinct(this.tester().getPlannerContext()).projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output", original.type()), original).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(rewritten)), PlanMatchPattern.values(new String[0])));
    }
}

