/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementTableFunctionSource;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestImplementTableFunctionSource
extends BaseRuleTest {
    private static final WindowNode.Frame FULL_FRAME = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());

    public TestImplementTableFunctionSource() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<PlanNode>)ImmutableList.of(), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of(), (List<List<String>>)ImmutableList.of())).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a"))));
    }

    @Test
    public void testSingleSourceWithRowSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", true, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)c), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", true, true, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, false))), (List)ImmutableList.of((Object)c), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testSingleSourceWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)d), (Map)ImmutableMap.of((Object)d, (Object)SortOrder.ASC_NULLS_LAST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.values("c", "d")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)d), (Map)ImmutableMap.of((Object)d, (Object)SortOrder.ASC_NULLS_LAST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.values("c", "d")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true), (Object)new TableFunctionNode.PassThroughColumn(d, false))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty())))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())), PlanMatchPattern.values("c", "d")));
    }

    @Test
    public void testTwoSourcesWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty())))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")))), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testThreeSourcesWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Symbol g = p.symbol("g");
            Symbol h = p.symbol("h");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f), (Object)p.values(g, h)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)h), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)h), (Map)ImmutableMap.of((Object)h, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"f"), (Object)ImmutableList.of((Object)"h"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2", (Object)"g", (Object)"marker_3", (Object)"h", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"))), (Object)"combined_partition_size_1_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size")))), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")))), PlanMatchPattern.join(JoinType.FULL, nestedJoinBuilder -> nestedJoinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"h"), (Map<String, SortOrder>)ImmutableMap.of((Object)"h", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_3_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_3_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("g", "h"))))))));
    }

    @Test
    public void testTwoCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)f), (Map)ImmutableMap.of((Object)f, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "e"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of((Object)"f"), (Map<String, SortOrder>)ImmutableMap.of((Object)"f", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testCoPartitionJoinTypes() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "c"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "c")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d"))))))));
    }

    @Test
    public void testThreeCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2", (Object)"input_3")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1_2_3"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3")), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"))), (Object)"combined_partition_size_1_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"))), (Object)"combined_partition_column_1_2_3", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_column_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "e"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_column_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column_1_2", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, nestedJoinBuilder -> nestedJoinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_3_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e"))))))));
    }

    @Test
    public void testTwoCoPartitionLists() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Symbol g = p.symbol("g");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e), (Object)p.values(f, g)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_4", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(f, true))), (List)ImmutableList.of((Object)g), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)f), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)g), (Map)ImmutableMap.of((Object)g, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2"), (Object)ImmutableList.of((Object)"input_3", (Object)"input_4")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"), (Object)ImmutableList.of((Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"), (Object)ImmutableList.of((Object)"g"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3", (Object)"f", (Object)"marker_4", (Object)"g", (Object)"marker_4")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1_2", (Object)"combined_partition_column_3_4"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3_4"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3_4", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3_4")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3_4")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3_4")), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_4", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2_3_4")), (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3_4", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_3_4"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_3_4"))), (Object)"combined_partition_size_1_2_3_4", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_3_4"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_3_4")))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_3_4")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_3_4")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_3_4"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_3_4"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_1_2")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_1_2"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column_1_2", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]))), PlanMatchPattern.join(JoinType.INNER, nestedJoinBuilder -> nestedJoinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d")))))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_3_4", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"))), (Object)"combined_partition_size_3_4", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_4_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_4_partition_size"))), (Object)"combined_partition_column_3_4", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "e"), (Expression)new Reference((Type)BigintType.BIGINT, "f"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, nestedJoinBuilder -> nestedJoinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "e"), (Expression)new Reference((Type)BigintType.BIGINT, "f")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_4_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_4_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_3_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"f"), (List<String>)ImmutableList.of((Object)"g"), (Map<String, SortOrder>)ImmutableMap.of((Object)"g", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_4_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_4_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("f", "g")))))))))));
    }

    @Test
    public void testCoPartitionedAndNotCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_2", (Object)"input_3")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_2_3", (Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number_2_3_1"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_2_3_1", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3_1")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3_1")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3_1")), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_2_3_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"))), (Object)"combined_partition_size_2_3_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_2_3"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_2_3"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")))), PlanMatchPattern.join(JoinType.INNER, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_partition_size_2_3")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number_2_3"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"))), (Object)"combined_partition_size_2_3", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size"))), (Object)"combined_partition_column_2_3", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, nestedJoinBuilder -> nestedJoinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_3_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_3_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_3_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c"))))))));
    }

    @Test
    public void testCoerceForCopartitioning() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c", (Type)TinyintType.TINYINT);
            Symbol cCoerced = p.symbol("c_coerced", (Type)IntegerType.INTEGER);
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e", (Type)IntegerType.INTEGER);
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.project(Assignments.builder().put(c, (Expression)new Reference((Type)TinyintType.TINYINT, "c")).put(d, (Expression)new Reference((Type)BigintType.BIGINT, "d")).put(cCoerced, (Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Type)IntegerType.INTEGER)).build(), (PlanNode)p.values(c, d)), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)cCoerced), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)f), (Map)ImmutableMap.of((Object)f, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"c_coerced", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c_coerced"), (Expression)new Reference((Type)BigintType.BIGINT, "e"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c_coerced"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c_coerced"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Type)IntegerType.INTEGER))), PlanMatchPattern.values("c", "d")))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of((Object)"f"), (Map<String, SortOrder>)ImmutableMap.of((Object)"f", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testTwoCoPartitioningColumns() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true), (Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c, (Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e, (Object)f), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1", (Object)"combined_partition_column_2"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"))), (Object)"combined_partition_column_1", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "e"), new Expression[0])), (Object)"combined_partition_column_2", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "f"), new Expression[0]))), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "d"), (Expression)new Reference((Type)BigintType.BIGINT, "f")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c", (Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e", (Object)"f"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testTwoSourcesWithRowAndSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", true, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)e), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null))), (Object)"marker_2", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "combined_row_number")), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"))), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-1L), new Expression[0])), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")))), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_2_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "input_2_row_number"), (Expression)new Reference((Type)BigintType.BIGINT, "input_1_partition_size")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "input_1_row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_1_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), FULL_FRAME)).addFunction("input_2_partition_size", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), FULL_FRAME)), PlanMatchPattern.values("e", "f"))))))));
    }
}

