/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;

public class TestMergeAdjacentWindows
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final ResolvedFunction AVG = FUNCTION_RESOLUTION.resolveFunction("avg", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction SUM = FUNCTION_RESOLUTION.resolveFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction LAG = FUNCTION_RESOLUTION.resolveFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final String columnAAlias = "ALIAS_A";
    private static final ExpectedValueProvider<DataOrganizationSpecification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ALIAS_A"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());

    public TestMergeAdjacentWindows() {
        super(new Plugin[0]);
    }

    @Test
    public void testPlanWithoutWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDistinctAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(SUM, "b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIntermediateNonProjectNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(1)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1", (Type)DoubleType.DOUBLE), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2", (Type)DoubleType.DOUBLE), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsDistinctSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIdenticalAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(new Symbol((Type)DoubleType.DOUBLE, "a")), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1", (Type)DoubleType.DOUBLE), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, new Symbol((Type)DoubleType.DOUBLE, "a"))), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(new Symbol((Type)DoubleType.DOUBLE, "a")), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1", (Type)DoubleType.DOUBLE), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(SUM, new Symbol((Type)DoubleType.DOUBLE, "a"))), (PlanNode)p.values(p.symbol("a", (Type)DoubleType.DOUBLE))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.windowFunction(AVG.signature().getName().getFunctionName(), (List<String>)ImmutableList.of((Object)columnAAlias), WindowNode.Frame.DEFAULT_FRAME)).addFunction(PlanMatchPattern.windowFunction(SUM.signature().getName().getFunctionName(), (List<String>)ImmutableList.of((Object)columnAAlias), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0))));
    }

    @Test
    public void testIntermediateProjectNodes() {
        String oneAlias = "ALIAS_one";
        String unusedAlias = "ALIAS_unused";
        String lagOutputAlias = "ALIAS_lagOutput";
        String avgOutputAlias = "ALIAS_avgOutput";
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(2)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(new Symbol((Type)DoubleType.DOUBLE, "a")), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("lagOutput"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(LAG, new Symbol((Type)DoubleType.DOUBLE, "a"), new Symbol((Type)IntegerType.INTEGER, "one"))), (PlanNode)p.project(Assignments.builder().put(p.symbol("one", (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)).putIdentities((Iterable)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "a"), (Object)p.symbol("avgOutput", (Type)DoubleType.DOUBLE))).build(), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{new Symbol((Type)DoubleType.DOUBLE, "a"), p.symbol("avgOutput", (Type)DoubleType.DOUBLE), p.symbol("unused")}), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(new Symbol((Type)DoubleType.DOUBLE, "a")), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avgOutput", (Type)DoubleType.DOUBLE), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a", (Type)DoubleType.DOUBLE), p.symbol("unused"))))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, columnAAlias)), (Object)oneAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, oneAlias)), (Object)lagOutputAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)DoubleType.DOUBLE, lagOutputAlias)), (Object)avgOutputAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)DoubleType.DOUBLE, avgOutputAlias))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(lagOutputAlias, PlanMatchPattern.windowFunction(LAG.signature().getName().getFunctionName(), (List<String>)ImmutableList.of((Object)columnAAlias, (Object)oneAlias), WindowNode.Frame.DEFAULT_FRAME)).addFunction(avgOutputAlias, PlanMatchPattern.windowFunction(AVG.signature().getName().getFunctionName(), (List<String>)ImmutableList.of((Object)columnAAlias), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)oneAlias, (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)columnAAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, columnAAlias)), (Object)unusedAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, unusedAlias))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, columnAAlias)), (Object)unusedAlias, (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, unusedAlias))), PlanMatchPattern.values(columnAAlias, unusedAlias))))));
    }

    private static DataOrganizationSpecification newWindowNodeSpecification(Symbol symbol) {
        return new DataOrganizationSpecification((List)ImmutableList.of((Object)symbol), Optional.empty());
    }

    private static DataOrganizationSpecification newWindowNodeSpecification(PlanBuilder planBuilder, String symbolName) {
        return new DataOrganizationSpecification((List)ImmutableList.of((Object)planBuilder.symbol(symbolName, (Type)BigintType.BIGINT)), Optional.empty());
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction, Symbol ... symbols) {
        return new WindowNode.Function(resolvedFunction, Arrays.stream(symbols).map(Symbol::toSymbolReference).collect(Collectors.toList()), WindowNode.Frame.DEFAULT_FRAME, false);
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction, String ... symbols) {
        return new WindowNode.Function(resolvedFunction, Arrays.stream(symbols).map(name -> new Reference((Type)DoubleType.DOUBLE, name)).collect(Collectors.toList()), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

