/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughExchange;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPushProjectionThroughExchange
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    public TestPushProjectionThroughExchange() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireNoExchange() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireNarrowingProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.builder().putIdentity(a).putIdentity(b).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, c)).addInputsSet(a, b, c).singleDistributionPartitioningScheme(a, b, c)));
        }).doesNotFire();
    }

    @Test
    public void testSimpleMultipleInputs() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol c2 = p.symbol("c2");
            Symbol x = p.symbol("x", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)x, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Symbol)c2, (Expression)new Reference((Type)BigintType.BIGINT, "c")), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addSource((PlanNode)p.values(b)).addInputsSet(a).addInputsSet(b).singleDistributionPartitioningScheme(c)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("x1", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"))).withAlias("x2", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)))).withAlias("x1").withAlias("x2"));
    }

    @Test
    public void testHashMapping() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol h1 = p.symbol("h_1");
            Symbol c = p.symbol("c", (Type)IntegerType.INTEGER);
            Symbol h = p.symbol("h");
            Symbol cTimes5 = p.symbol("c_times_5", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)cTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "c"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, h1)).addInputsSet(a, h1).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)c, (Object)h), (List<Symbol>)ImmutableList.of((Object)c), h)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Object)"h_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "h_1")), (Object)"a_times_5", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"h_1"))))));
    }

    @Test
    public void testSkipIdentityProjectionIfOutputPresent() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol aTimes5 = p.symbol("a_times_5", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)aTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of((Object)a))));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Object)"a_times_5", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol bTimes5 = p.symbol("b_times_5", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.project(Assignments.of((Symbol)bTimes5, (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L))), (Symbol)b, (Expression)b.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)b), (List<Symbol>)ImmutableList.of((Object)b))));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"a_times_5", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
    }

    @Test
    public void testDoNotSkipIdentityProjectionIfOutputAbsent() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol aTimes5 = p.symbol("a_times_5", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)aTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(a)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "a")), (Object)"a_times_5", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol bTimes5 = p.symbol("b_times_5", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.project(Assignments.of((Symbol)bTimes5, (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L))), (Symbol)b, (Expression)b.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(b)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"a_times_5", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
    }

    @Test
    public void testPartitioningColumnAndHashWithoutIdentityMappingInProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol b = p.symbol("b", (Type)IntegerType.INTEGER);
            Symbol h = p.symbol("h", (Type)IntegerType.INTEGER);
            Symbol aTimes5 = p.symbol("a_times_5", (Type)IntegerType.INTEGER);
            Symbol bTimes5 = p.symbol("b_times_5", (Type)IntegerType.INTEGER);
            Symbol hTimes5 = p.symbol("h_times_5", (Type)IntegerType.INTEGER);
            return p.project(Assignments.builder().put(aTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).put(bTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).put(hTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "h"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h)).addInputsSet(a, b, h).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)h), (List<Symbol>)ImmutableList.of((Object)b), h)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h"))).withNumberOfOutputColumns(5).withAlias("b", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "b"))).withAlias("h", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "h"))).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "h"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }

    @Test
    public void testOrderingColumnsArePreserved() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol b = p.symbol("b", (Type)IntegerType.INTEGER);
            Symbol h = p.symbol("h", (Type)IntegerType.INTEGER);
            Symbol aTimes5 = p.symbol("a_times_5", (Type)IntegerType.INTEGER);
            Symbol bTimes5 = p.symbol("b_times_5", (Type)IntegerType.INTEGER);
            Symbol hTimes5 = p.symbol("h_times_5", (Type)IntegerType.INTEGER);
            Symbol sortSymbol = p.symbol("sortSymbol");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)sortSymbol), (Map)ImmutableMap.of((Object)sortSymbol, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.project(Assignments.builder().put(aTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).put(bTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).put(hTimes5, (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "h"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L)))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h, sortSymbol)).addInputsSet(a, b, h, sortSymbol).singleDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)h, (Object)sortSymbol)).orderingScheme(orderingScheme)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("sortSymbol", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h", (Object)"sortSymbol"))).withNumberOfOutputColumns(4).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "h"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))))).withAlias("sortSymbol", (RvalueMatcher)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "sortSymbol"))))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }
}

