/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveEmptyMergeWriterRuleSet;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.List;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRemoveEmptyMergeWriterRuleSet
extends BaseRuleTest {
    private CatalogHandle catalogHandle;
    private SchemaTableName schemaTableName;

    public TestRemoveEmptyMergeWriterRuleSet() {
        super(new Plugin[0]);
    }

    @BeforeAll
    public void setup() {
        this.catalogHandle = this.tester().getCurrentCatalogHandle();
        this.schemaTableName = new SchemaTableName("schema", "table");
    }

    @Test
    public void testRemoveEmptyMergeRewrite() {
        this.testRemoveEmptyMergeRewrite((Rule<TableFinishNode>)RemoveEmptyMergeWriterRuleSet.removeEmptyMergeWriterRule(), false);
    }

    @Test
    public void testRemoveEmptyMergeRewriteWithExchange() {
        this.testRemoveEmptyMergeRewrite((Rule<TableFinishNode>)RemoveEmptyMergeWriterRuleSet.removeEmptyMergeWriterWithExchangeRule(), true);
    }

    private void testRemoveEmptyMergeRewrite(Rule<TableFinishNode> rule, boolean planWithExchange) {
        this.tester().assertThat(rule).on(p -> {
            Symbol mergeRow = p.symbol("merge_row");
            Symbol rowId = p.symbol("row_id");
            Symbol rowCount = p.symbol("row_count");
            MergeWriterNode merge = p.merge(this.schemaTableName, (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.project(Assignments.builder().putIdentity(mergeRow).putIdentity(rowId).putIdentity(rowCount).build(), (PlanNode)p.values(mergeRow, rowId, rowCount))).addInputsSet(mergeRow, rowId, rowCount).partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, List.of()), List.of(mergeRow, rowId, rowCount)))), mergeRow, rowId, List.of(rowCount));
            return p.tableFinish((PlanNode)(planWithExchange ? this.withExchange((PlanBuilder)p, (PlanNode)merge, rowCount) : merge), (TableWriterNode.WriterTarget)p.createTarget(this.catalogHandle, this.schemaTableName, true, WriterScalingOptions.ENABLED, false), rowCount);
        }).matches(PlanMatchPattern.values("A"));
    }

    private ExchangeNode withExchange(PlanBuilder planBuilder, PlanNode source, Symbol symbol) {
        return planBuilder.exchange(e -> e.addSource(source).addInputsSet(symbol).partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, List.of()), List.of(symbol))));
    }
}

