/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveEmptyUnionBranches;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRemoveEmptyUnionBranches
extends BaseRuleTest {
    public TestRemoveEmptyUnionBranches() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotEliminateNonEmptyBranches() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyUnionBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(2, input2)));
        }).doesNotFire();
    }

    @Test
    public void testRemoveEmptyBranches() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyUnionBranches()).on(p -> {
            Symbol output = p.symbol("output", (Type)BigintType.BIGINT);
            Symbol input1 = p.symbol("input1", (Type)BigintType.BIGINT);
            Symbol input2 = p.symbol("input2", (Type)BigintType.BIGINT);
            Symbol input3 = p.symbol("input3", (Type)BigintType.BIGINT);
            Symbol input4 = p.symbol("input4", (Type)BigintType.BIGINT);
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).put((Object)output, (Object)input3).put((Object)output, (Object)input4).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(0, input2), (Object)p.values(2, input3), (Object)p.values(0, input4)));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.values(List.of("input1"), List.of(List.of(new Constant((Type)BigintType.BIGINT, null)))), PlanMatchPattern.values(List.of("input3"), List.of(List.of(new Constant((Type)BigintType.BIGINT, null)), List.of(new Constant((Type)BigintType.BIGINT, null))))));
    }

    @Test
    public void testReplaceUnionWithProjection() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyUnionBranches()).on(p -> {
            Symbol output = p.symbol("output", (Type)BigintType.BIGINT);
            Symbol input1 = p.symbol("input1", (Type)BigintType.BIGINT);
            Symbol input2 = p.symbol("input2", (Type)BigintType.BIGINT);
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(0, input2)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "input1"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"input1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))));
    }

    @Test
    public void testAllEmptyBranches() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyUnionBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(0, input1), (Object)p.values(0, input2)));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"output"), (List<List<Expression>>)ImmutableList.of()));
    }
}

