/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSort;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantSort
extends BaseRuleTest {
    public TestRemoveRedundantSort() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testForZeroCardinality() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.values(p.symbol("foo")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "foo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(20, p.symbol("foo")))))).doesNotFire();
    }
}

