/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSortBelowLimitWithTies;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantSortBelowLimitWithTies
extends BaseRuleTest {
    public TestRemoveRedundantSortBelowLimitWithTies() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveSort() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSortBelowLimitWithTies()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(5L, (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.limit(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST), (Object)PlanMatchPattern.sort("b", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new RemoveRedundantSortBelowLimitWithTies()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.limit(5L, (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)c, (Object)d), (PlanNode)p.values(a, b, c, d)));
        }).matches(PlanMatchPattern.limit(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST), (Object)PlanMatchPattern.sort("b", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b", "c", "d")));
    }
}

