/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceWindowWithRowNumber;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestReplaceWindowWithRowNumber
extends BaseRuleTest {
    public TestReplaceWindowWithRowNumber() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        ResolvedFunction rowNumberFunction = this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new ReplaceWindowWithRowNumber(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rowNumberFunction)), (PlanNode)p.values(a));
        }).matches(PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.empty()).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new ReplaceWindowWithRowNumber(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rowNumberFunction)), (PlanNode)p.values(a));
        }).matches(PlanMatchPattern.rowNumber(pattern -> pattern.maxRowCountPerPartition(Optional.empty()).partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values("a")));
    }

    @Test
    public void testDoNotFire() {
        ResolvedFunction rank = this.tester().getMetadata().resolveBuiltinFunction("rank", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new ReplaceWindowWithRowNumber(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rank1 = p.symbol("rank_1");
            return p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rank1, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rank)), (PlanNode)p.values(a));
        }).doesNotFire();
        ResolvedFunction rowNumber = this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new ReplaceWindowWithRowNumber(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber1 = p.symbol("row_number_1");
            Symbol rank1 = p.symbol("rank_1");
            return p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber1, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rowNumber), (Object)rank1, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rank)), (PlanNode)p.values(a));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceWindowWithRowNumber(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            Symbol rowNumber1 = p.symbol("row_number_1");
            return p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber1, (Object)TestReplaceWindowWithRowNumber.newWindowNodeFunction(rowNumber)), (PlanNode)p.values(a));
        }).doesNotFire();
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction) {
        return new WindowNode.Function(resolvedFunction, (List)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

