/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestSimplifyFilterPredicate
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestSimplifyFilterPredicate() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimplifyIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.TRUE, (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.TRUE, (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.FALSE, (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.TRUE, (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.FALSE, (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("a", "b")));
        Call randomFunction = new Call(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)randomFunction, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)randomFunction, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)Booleans.TRUE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter(TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter(IrExpressions.ifExpression((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.TRUE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifyNullIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new NullIf((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "a"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (Object)TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "b")))))), PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testSimplifySearchedCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE)), (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE)), (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE)), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)TestSimplifyFilterPredicate.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)TestSimplifyFilterPredicate.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE)), (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)BooleanType.BOOLEAN, null)), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)TestSimplifyFilterPredicate.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)TestSimplifyFilterPredicate.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)TestSimplifyFilterPredicate.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)Booleans.FALSE, TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Constant((Type)BooleanType.BOOLEAN, null), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "b"))), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.FALSE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "b"))), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))), (Object)new WhenClause((Expression)Booleans.TRUE, (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (Object)new WhenClause((Expression)Booleans.TRUE, TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "b")))), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a")), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "b"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), TestSimplifyFilterPredicate.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "a")))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifySimpleCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.FALSE)), (Expression)new Reference((Type)BooleanType.BOOLEAN, "b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"), (Expression)Booleans.FALSE)), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Reference((Type)IntegerType.INTEGER, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)Booleans.TRUE), (Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)Booleans.TRUE)), (Expression)Booleans.TRUE), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Reference((Type)IntegerType.INTEGER, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)Booleans.FALSE), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(FUNCTIONS.getMetadata())).on(p -> p.filter((Expression)new Switch((Expression)new Reference((Type)IntegerType.INTEGER, "a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)Booleans.FALSE), (Object)new WhenClause((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)BooleanType.BOOLEAN, null))), (Expression)Booleans.NULL_BOOLEAN), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)Booleans.FALSE, PlanMatchPattern.values("a", "b")));
    }

    private static Expression not(Expression expression) {
        return IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)expression);
    }
}

