/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedGlobalAggregationWithProjection
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestTransformCorrelatedGlobalAggregationWithProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnPlanWithoutCorrelatedJoinNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnCorrelatedWithoutAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnCorrelatedWithNonScalarAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnMultipleProjections() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_2", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "expr"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnSubqueryWithoutProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).doesNotFire();
    }

    @Test
    public void testRewritesOnSubqueryWithProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum_1"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void testRewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Symbol)p.symbol("expr_count", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "count"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"expr_sum", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum_agg"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Object)"expr_count", (Object)PlanMatchPattern.expression((Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "count_agg"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "non_null", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void testRewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Symbol)p.symbol("expr_count", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "count"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"expr_sum", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum_agg"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Object)"expr_count", (Object)PlanMatchPattern.expression((Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "count_agg"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void testWithPreexistingMask() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("mask", (Type)BooleanType.BOOLEAN))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("mask", (Type)BooleanType.BOOLEAN)).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum_1"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_1"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "mask"), (Object)new Reference((Type)BooleanType.BOOLEAN, "non_null"))))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"mask", (Object)1)))))))));
    }

    @Test
    public void testRewritesOnSubqueryWithBoolOr() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr", (Type)BigintType.BIGINT)), (PlanNode)p.values(p.symbol("corr", (Type)BigintType.BIGINT)), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("exists", (Type)BooleanType.BOOLEAN), (Expression)new Coalesce((Expression)new Reference((Type)BooleanType.BOOLEAN, "aggrbool"), (Expression)Booleans.FALSE, new Expression[0])), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("subquery", (Type)BooleanType.BOOLEAN))).addAggregation(p.symbol("aggrbool", (Type)BooleanType.BOOLEAN), PlanBuilder.aggregation("bool_or", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "subquery"))), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"exists", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BooleanType.BOOLEAN, "aggrbool"), (Expression)Booleans.FALSE, new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("aggrbool"), PlanMatchPattern.aggregationFunction("bool_or", (List<String>)ImmutableList.of((Object)"subquery"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"subquery", (Object)0)))))));
    }
}

