/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedJoinToJoin
extends BaseRuleTest {
    public TestTransformCorrelatedJoinToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteInnerCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.INNER, (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L))))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testRewriteLeftCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.LEFT, (Expression)Booleans.TRUE, (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a"))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.LEFT, (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), (PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "b"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L))))).left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.values("b")))));
    }

    @Test
    public void doesNotFireForEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)Booleans.TRUE, (PlanNode)p.enforceSingleRow((PlanNode)p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "corr"), (Expression)new Reference((Type)BigintType.BIGINT, "a")), (PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }
}

