/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExpressionRewriteInRowPatternMatching {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testDesugarArrayConstructor() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.array, m.sum           FROM (VALUES (1), (2), (3)) t(id)                  MATCH_RECOGNIZE (                    ORDER BY id                    MEASURES                            CLASSIFIER() AS classy,                            ARRAY['foo', CLASSIFIER()] AS array,                            sum(array_max(ARRAY[MATCH_NUMBER()])) AS sum                    ALL ROWS PER MATCH                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN ((A | B)* X)                    DEFINE X AS array_agg(CLASSIFIER()) = ARRAY['B', 'A', 'X'] AND                                sum(array_max(ARRAY[MATCH_NUMBER()])) = 3                 ) AS m"))).matches("VALUES      (1, VARCHAR 'B', ARRAY[VARCHAR 'foo', 'B'], BIGINT '1'),      (2, 'A',         ARRAY['foo', 'A'],         2),      (3, 'X',         ARRAY['foo', 'X'],         3)");
    }

    @Test
    public void testDesugarLike() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.measure_1, m.measure_2           FROM (VALUES (1), (2), (3)) t(id)                  MATCH_RECOGNIZE (                    ORDER BY id                    MEASURES                            CLASSIFIER() AS classy,                            CLASSIFIER() LIKE '%X' AS measure_1,                            bool_or(CLASSIFIER() LIKE '%B') AS measure_2                    ALL ROWS PER MATCH                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN ((A | B)* X)                    DEFINE X AS PREV(CLASSIFIER()) LIKE '%B' AND                                bool_or(CLASSIFIER() LIKE '%A')                 ) AS m"))).matches("VALUES      (1, VARCHAR 'A', false, false),      (2, 'B',         false, true),      (3, 'X',         true , true)");
    }

    @Test
    public void testSimplifyExpressions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT m.id, m.classy, m.measure_1, m.measure_2           FROM (VALUES (1), (2), (3)) t(id)                  MATCH_RECOGNIZE (                    ORDER BY id                    MEASURES                            CLASSIFIER() AS classy,                            true OR MATCH_NUMBER() / 0 > 0 AS measure_1,                            bool_and(MATCH_NUMBER() / 0 > 0 AND false) AS measure_2                    ALL ROWS PER MATCH                    AFTER MATCH SKIP PAST LAST ROW                    PATTERN ((A | B)* X)                    DEFINE X AS IF(false, 0 / 0, MATCH_NUMBER()) = 1 OR                                 bool_and(MATCH_NUMBER() / 0 > 0 AND false)                 ) AS m"))).matches("VALUES      (1, VARCHAR 'A', true, false),      (2, 'A',         true, false),      (3, 'X',         true, false)");
    }
}

