/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestFormat {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testAggregationInFormat() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%.6f', sum(1000000 / 1e6))"))).matches("SELECT cast(1.000000 as varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%.6f', avg(1))"))).matches("SELECT cast(1.000000 as varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%d', count(1))"))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%d', arbitrary(1))"))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%s %s %s %s %s', sum(1), avg(1), count(1), max(1), min(1))"))).matches("SELECT VARCHAR '1 1.0 1 1 1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%s', approx_distinct(1.0))"))).matches("SELECT cast(1 as varchar)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%d', cast(sum(totalprice) as bigint)) FROM (VALUES 20,99,15) t(totalprice)"))).matches("SELECT CAST(sum(totalprice) as VARCHAR) FROM (VALUES 20,99,15) t(totalprice)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format('%s', sum(k)) FROM (VALUES 1, 2, 3) t(k)"))).matches("VALUES VARCHAR '6'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format(arbitrary(s), sum(k)) FROM (VALUES ('%s', 1), ('%s', 2), ('%s', 3)) t(s, k)"))).matches("VALUES VARCHAR '6'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT format(s, 1) FROM (VALUES ('%s', 1)) t(s, k) GROUP BY k"))).failure().hasMessageMatching("\\Qline 1:8: 'format(s, 1)' must be an aggregate expression or appear in GROUP BY clause\\E");
    }
}

