/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMergeProjectWithValues {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testMergeProjectWithValues() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b + 1, 'x' FROM (VALUES (1, 10, true), (2, 20, false), (3, 30, true)) t(a, b, c)"))).matches("VALUES (1, 11, 'x'), (2, 21, 'x'), (3, 31, 'x')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b + 1, 'x' FROM (VALUES (1, 10, true), (null, null, null), (3, 30, true)) t(a, b, c)"))).matches("VALUES (1, 11, 'x'), (null, null, 'x'), (3, 31, 'x')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT a * 10 FROM (VALUES x) t(a)) FROM (VALUES 1, 2, 3) t2(x)"))).matches("VALUES 10, 20, 30");
    }
}

