/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.CharacterStringCasts;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCharacterStringCasts {
    private static final String NON_BMP_CHARACTER = new String(Character.toChars(128269));
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testVarcharToVarcharCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(20))").binding("a", "'bar'")))).hasType((Type)VarcharType.createVarcharType((int)20)).isEqualTo("bar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as varchar(20)) as varchar(30))").binding("a", "'bar'")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("bar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as varchar(20)) as varchar)").binding("a", "'bar'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("bar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(3))").binding("a", "'banana'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("ban");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as varchar(20)) as varchar(3))").binding("a", "'banana'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("ban");
    }

    @Test
    public void testVarcharToCharCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as char(10))").binding("a", "'bar  '")))).hasType((Type)CharType.createCharType((int)10)).isEqualTo("bar       ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as char)").binding("a", "'bar'")))).hasType((Type)CharType.createCharType((int)1)).isEqualTo("b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as char)").binding("a", "'   '")))).hasType((Type)CharType.createCharType((int)1)).isEqualTo(" ");
    }

    @Test
    public void testCharToVarcharCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(5)) as varchar(10))").binding("a", "'bar'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("bar  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(5)) as varchar(1))").binding("a", "'bar'")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(5)) as varchar(2))").binding("a", "'b'")))).hasType((Type)VarcharType.createVarcharType((int)2)).isEqualTo("b ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(5)) as varchar(1))").binding("a", "'b'")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(3)) as varchar(3))").binding("a", "'bar'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("bar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(cast(a as char(3)) as varchar(3))").binding("a", "'b'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("b  ");
    }

    @Test
    public void testVarcharToCharSaturatedFloorCast() {
        String nonBmpCharacterMinusOne = new String(Character.toChars(128268));
        String maxCodePoint = new String(Character.toChars(0x10FFFF));
        String codePointBeforeSpace = new String(Character.toChars(31));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)5L, (Slice)Slices.utf8Slice((String)("123" + new String(Character.toChars(57344)))))).isEqualTo((Object)Slices.utf8Slice((String)("123" + new String(Character.toChars(55295)) + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12345"))).isEqualTo((Object)Slices.utf8Slice((String)"1234"));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1234"))).isEqualTo((Object)Slices.utf8Slice((String)"1234"));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("123" + NON_BMP_CHARACTER)))).isEqualTo((Object)Slices.utf8Slice((String)("123" + NON_BMP_CHARACTER)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("12" + NON_BMP_CHARACTER + "3")))).isEqualTo((Object)Slices.utf8Slice((String)("12" + NON_BMP_CHARACTER + "3")));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"123 "))).isEqualTo((Object)Slices.utf8Slice((String)"123"));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"123"))).isEqualTo((Object)Slices.utf8Slice((String)("122" + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12 "))).isEqualTo((Object)Slices.utf8Slice((String)("12" + codePointBeforeSpace + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1  "))).isEqualTo((Object)Slices.utf8Slice((String)("1 " + codePointBeforeSpace + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)" "))).isEqualTo((Object)Slices.utf8Slice((String)(codePointBeforeSpace + maxCodePoint + maxCodePoint + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("12" + NON_BMP_CHARACTER)))).isEqualTo((Object)Slices.utf8Slice((String)("12" + nonBmpCharacterMinusOne + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)("1" + NON_BMP_CHARACTER + "3")))).isEqualTo((Object)Slices.utf8Slice((String)("1" + NON_BMP_CHARACTER + "2" + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"12\u0000"))).isEqualTo((Object)Slices.utf8Slice((String)("11" + maxCodePoint + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"1\u0000"))).isEqualTo((Object)Slices.utf8Slice((String)("0" + maxCodePoint + maxCodePoint + maxCodePoint)));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"\u0000"))).isEqualTo((Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)"\u0000\u0000"))).isEqualTo((Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToCharSaturatedFloorCast((long)4L, (Slice)Slices.utf8Slice((String)""))).isEqualTo((Object)Slices.utf8Slice((String)"\u0000\u0000\u0000\u0000"));
    }

    @Test
    public void testVarcharToVarcharSaturatedFloorCast() {
        this.assertVarcharToVarcharSaturatedFloorCast(4L, "12345", "1234");
        this.assertVarcharToVarcharSaturatedFloorCast(5L, "12345", "12345");
        this.assertVarcharToVarcharSaturatedFloorCast(6L, "12345", "12345");
        this.assertVarcharToVarcharSaturatedFloorCast(4L, "123  ", "123 ");
        this.assertVarcharToVarcharSaturatedFloorCast(5L, "123  ", "123  ");
        this.assertVarcharToVarcharSaturatedFloorCast(4L, "1234" + NON_BMP_CHARACTER, "1234");
        this.assertVarcharToVarcharSaturatedFloorCast(5L, "1234" + NON_BMP_CHARACTER, "1234" + NON_BMP_CHARACTER);
        this.assertVarcharToVarcharSaturatedFloorCast(6L, "1234" + NON_BMP_CHARACTER, "1234" + NON_BMP_CHARACTER);
    }

    private void assertVarcharToVarcharSaturatedFloorCast(long length, String baseString, String expected) {
        Assertions.assertThat((Comparable)CharacterStringCasts.varcharToVarcharSaturatedFloorCast((long)length, (Slice)Slices.utf8Slice((String)baseString))).isEqualTo((Object)Slices.utf8Slice((String)expected));
    }
}

