/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.SqlIntervalYearMonth;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIntervalYearMonth {
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testObject() {
        Assertions.assertThat((Object)new SqlIntervalYearMonth(3, 11)).isEqualTo((Object)new SqlIntervalYearMonth(47));
        Assertions.assertThat((Object)new SqlIntervalYearMonth(-3, -11)).isEqualTo((Object)new SqlIntervalYearMonth(-47));
        Assertions.assertThat((Object)new SqlIntervalYearMonth(Short.MAX_VALUE, 0)).isEqualTo((Object)new SqlIntervalYearMonth(393204));
        Assertions.assertThat((Object)new SqlIntervalYearMonth(Short.MAX_VALUE, Short.MAX_VALUE)).isEqualTo((Object)new SqlIntervalYearMonth(425971));
        Assertions.assertThat((Object)new SqlIntervalYearMonth(-32767, 0)).isEqualTo((Object)new SqlIntervalYearMonth(-393204));
        Assertions.assertThat((Object)new SqlIntervalYearMonth(-32767, -32767)).isEqualTo((Object)new SqlIntervalYearMonth(-425971));
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' MONTH", "INTERVAL '3' MONTH")))).matches("INTERVAL '6' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '6' YEAR", "INTERVAL '6' YEAR")))).matches("INTERVAL '12' YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' MONTH", "INTERVAL '6' YEAR")))).matches("INTERVAL '6-3' YEAR TO MONTH");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '6' MONTH", "INTERVAL '3' MONTH")))).matches("INTERVAL '3' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '9' YEAR", "INTERVAL '6' YEAR")))).matches("INTERVAL '3' YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '3' MONTH", "INTERVAL '6' YEAR")))).matches("INTERVAL '-5-9' YEAR TO MONTH");
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' MONTH", "2")))).matches("INTERVAL '12' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2", "INTERVAL '6' MONTH")))).matches("INTERVAL '12' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '10' MONTH", "2.5")))).matches("INTERVAL '25' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2.5", "INTERVAL '10' MONTH")))).matches("INTERVAL '25' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' YEAR", "2")))).matches("INTERVAL '12' YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2", "INTERVAL '6' YEAR")))).matches("INTERVAL '12' YEAR");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '1' YEAR", "2.5")))).matches("INTERVAL '2-6' YEAR TO MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2.5", "INTERVAL '1' YEAR")))).matches("INTERVAL '2-6' YEAR TO MONTH");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' MONTH", "nan()")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "nan()", "INTERVAL '6' YEAR")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '30' MONTH", "2")))).matches("INTERVAL '15' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '60' MONTH", "2.5")))).matches("INTERVAL '24' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '3' YEAR", "2")))).matches("INTERVAL '18' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '4' YEAR", "4.8")))).matches("INTERVAL '10' MONTH");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' MONTH", "nan()")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' YEAR", "nan()")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' MONTH", "0E0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' YEAR", "0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "INTERVAL '3' MONTH")))).matches("INTERVAL '-3' MONTH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "INTERVAL '6' YEAR")))).matches("INTERVAL '-72' MONTH");
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '3' MONTH", "INTERVAL '3' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '6' YEAR", "INTERVAL '6' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '3' MONTH", "INTERVAL '4' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '7' YEAR", "INTERVAL '6' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '4' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '7' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '3' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '6' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' MONTH", "INTERVAL '4' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' YEAR", "INTERVAL '7' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' MONTH", "INTERVAL '3' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' MONTH", "INTERVAL '2' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' YEAR", "INTERVAL '6' YEAR")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' YEAR", "INTERVAL '5' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' MONTH", "INTERVAL '4' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' MONTH", "INTERVAL '3' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' YEAR", "INTERVAL '6' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' YEAR", "INTERVAL '7' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' MONTH", "INTERVAL '2' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' YEAR", "INTERVAL '5' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '2' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '5' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '3' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '4' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '6' YEAR")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '7' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '2' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '3' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '5' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '6' YEAR")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' MONTH").binding("b", "INTERVAL '4' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' YEAR").binding("b", "INTERVAL '7' YEAR")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '2' MONTH").binding("high", "INTERVAL '4' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '3' MONTH").binding("high", "INTERVAL '4' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '2' MONTH").binding("high", "INTERVAL '3' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '3' MONTH").binding("high", "INTERVAL '3' MONTH")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '4' MONTH").binding("high", "INTERVAL '5' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '1' MONTH").binding("high", "INTERVAL '2' MONTH")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' MONTH").binding("low", "INTERVAL '4' MONTH").binding("high", "INTERVAL '2' MONTH")))).isEqualTo(false);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '124-30' YEAR TO MONTH")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("126-6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '124-30' YEAR TO MONTH")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("126-6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '124' YEAR TO MONTH")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("124-0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '124' YEAR")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("124-0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '30' MONTH")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2-6");
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as INTERVAL YEAR TO MONTH)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "INTERVAL '124' YEAR TO MONTH")))).isEqualTo(false);
    }
}

