/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.trino.metadata.FunctionManager;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.DynamicPageFilter;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public final class DynamicFiltersTestUtil {
    private DynamicFiltersTestUtil() {
    }

    public static String getSimplifiedDomainString(long low, long high, int rangeCount, Type type) {
        String formattedValues = rangeCount == 1 ? String.format("{[%d]}", low) : (rangeCount == 2 ? LongStream.of(low, high).mapToObj(value -> "[" + value + "]").collect(Collectors.joining(", ", "{", "}")) : String.format("{[%d], ..., [%d]}", low, high));
        return "[ " + String.valueOf(new StringJoiner(", ", SortedRangeSet.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(type)).add("ranges=" + rangeCount).add(formattedValues)) + " ]";
    }

    public static FilterEvaluator createDynamicFilterEvaluator(TupleDomain<ColumnHandle> tupleDomain, Map<ColumnHandle, Integer> channels) {
        return DynamicFiltersTestUtil.createDynamicFilterEvaluator(tupleDomain, channels, 1.0);
    }

    public static FilterEvaluator createDynamicFilterEvaluator(TupleDomain<ColumnHandle> tupleDomain, Map<ColumnHandle, Integer> channels, double selectivityThreshold) {
        TestingDynamicFilter dynamicFilter = new TestingDynamicFilter(1);
        dynamicFilter.update(tupleDomain);
        Map types = (Map)((Map)tupleDomain.getDomains().orElse(ImmutableMap.of())).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Domain)entry.getValue()).getType()));
        int index = 0;
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableMap.Builder layout = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, Integer> entry2 : channels.entrySet()) {
            ColumnHandle column = entry2.getKey();
            Symbol symbol = new Symbol((Type)types.get(column), "col" + index++);
            columns.put((Object)symbol, (Object)column);
            int channel = entry2.getValue();
            layout.put((Object)symbol, (Object)channel);
        }
        return (FilterEvaluator)new DynamicPageFilter(TestingPlannerContext.PLANNER_CONTEXT, TestingSession.testSessionBuilder().build(), (Map)columns.buildOrThrow(), (Map)layout.buildOrThrow(), selectivityThreshold).createDynamicPageFilterEvaluator(new ColumnarFilterCompiler(FunctionManager.createTestingFunctionManager(), 0), (DynamicFilter)dynamicFilter).get();
    }

    public static class TestingDynamicFilter
    implements DynamicFilter {
        private CompletableFuture<?> isBlocked;
        private TupleDomain<ColumnHandle> currentPredicate;
        private int futuresLeft;

        public TestingDynamicFilter(int expectedFilters) {
            this.futuresLeft = expectedFilters;
            this.isBlocked = expectedFilters == 0 ? NOT_BLOCKED : new CompletableFuture();
            this.currentPredicate = TupleDomain.all();
        }

        public void update(TupleDomain<ColumnHandle> predicate) {
            --this.futuresLeft;
            Verify.verify((this.futuresLeft >= 0 ? 1 : 0) != 0);
            this.currentPredicate = this.currentPredicate.intersect(predicate);
            CompletableFuture<?> currentFuture = this.isBlocked;
            this.isBlocked = this.isComplete() ? NOT_BLOCKED : new CompletableFuture();
            Verify.verify((boolean)currentFuture.complete(null));
        }

        public Set<ColumnHandle> getColumnsCovered() {
            return ((Map)this.currentPredicate.getDomains().orElseThrow()).keySet();
        }

        public CompletableFuture<?> isBlocked() {
            return MoreFutures.unmodifiableFuture(this.isBlocked);
        }

        public boolean isComplete() {
            return this.futuresLeft == 0;
        }

        public boolean isAwaitable() {
            return this.futuresLeft > 0;
        }

        public TupleDomain<ColumnHandle> getCurrentPredicate() {
            return this.currentPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingDynamicFilter that = (TestingDynamicFilter)o;
            return this.futuresLeft == that.futuresLeft && Objects.equals(this.isBlocked, that.isBlocked) && Objects.equals(this.currentPredicate, that.currentPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.isBlocked, this.currentPredicate, this.futuresLeft);
        }
    }
}

