/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.execution.ExecutionFailureInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.util.Failures;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFailures {
    @Test
    public void testToFailureLoop() {
        Throwable exception1 = new TrinoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        RuntimeException exception2 = new RuntimeException("fake exception 2", exception1);
        exception1.addSuppressed(exception2);
        ExecutionFailureInfo failure = Failures.toFailure((Throwable)exception1);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("fake exception 1");
        Assertions.assertThat((Object)failure.getCause()).isNull();
        Assertions.assertThat((int)failure.getSuppressed().size()).isEqualTo(1);
        Assertions.assertThat((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage()).isEqualTo("fake exception 2");
        Assertions.assertThat((Object)failure.getErrorCode()).isEqualTo((Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        failure = Failures.toFailure((Throwable)exception2);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("fake exception 2");
        Assertions.assertThat((Object)failure.getCause()).isNotNull();
        Assertions.assertThat((String)failure.getCause().getMessage()).isEqualTo("fake exception 1");
        Assertions.assertThat((int)failure.getSuppressed().size()).isEqualTo(0);
        Assertions.assertThat((Object)failure.getErrorCode()).isEqualTo((Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new TrinoException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, "fake exception 1");
        exception2 = new RuntimeException("fake exception 2");
        exception1.addSuppressed(exception2);
        exception2.addSuppressed(exception1);
        failure = Failures.toFailure((Throwable)exception1);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("fake exception 1");
        Assertions.assertThat((Object)failure.getCause()).isNull();
        Assertions.assertThat((int)failure.getSuppressed().size()).isEqualTo(1);
        Assertions.assertThat((String)((ExecutionFailureInfo)failure.getSuppressed().get(0)).getMessage()).isEqualTo("fake exception 2");
        Assertions.assertThat((Object)failure.getErrorCode()).isEqualTo((Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        exception1 = new RuntimeException("fake exception 1");
        exception2 = new RuntimeException("fake exception 2", exception1);
        exception1.initCause(exception2);
        failure = Failures.toFailure((Throwable)exception2);
        Assertions.assertThat((String)failure.getMessage()).isEqualTo("fake exception 2");
        Assertions.assertThat((Object)failure.getCause()).isNotNull();
        Assertions.assertThat((String)failure.getCause().getMessage()).isEqualTo("fake exception 1");
        Assertions.assertThat((int)failure.getSuppressed().size()).isEqualTo(0);
        Assertions.assertThat((Object)failure.getErrorCode()).isEqualTo((Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
    }
}

