/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.datamodel;

import org.openjdk.jol.datamodel.DataModel;

public class Model64_Lilliput
implements DataModel {
    private final int align;
    private final boolean compRefs;
    private final boolean target;

    public Model64_Lilliput() {
        this(false, 8, false);
    }

    public Model64_Lilliput(boolean compRefs, int align, boolean target) {
        this.compRefs = compRefs;
        this.align = align;
        this.target = target;
    }

    @Override
    public int markHeaderSize() {
        return this.target ? 1 : 8;
    }

    @Override
    public int classHeaderSize() {
        return this.target ? 3 : 0;
    }

    @Override
    public int arrayLengthHeaderSize() {
        return 4;
    }

    @Override
    public int headerSize() {
        return this.markHeaderSize() + this.classHeaderSize();
    }

    @Override
    public int arrayHeaderSize() {
        return this.headerSize() + this.arrayLengthHeaderSize();
    }

    @Override
    public int sizeOf(String klass) {
        switch (klass) {
            case "byte": 
            case "boolean": {
                return 1;
            }
            case "short": 
            case "char": {
                return 2;
            }
            case "int": 
            case "float": {
                return 4;
            }
            case "long": 
            case "double": {
                return 8;
            }
        }
        return this.compRefs ? 4 : 8;
    }

    @Override
    public int objectAlignment() {
        return this.align;
    }

    public String toString() {
        return "64-bit model, Lilliput (" + (this.target ? "ultimate target" : "current experiment") + "), " + (this.compRefs ? "" : "NO ") + "compressed references, compressed classes, " + this.align + "-byte aligned";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model64_Lilliput that = (Model64_Lilliput)o;
        return this.align == that.align;
    }

    public int hashCode() {
        return this.align;
    }
}

