/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.airlift.jmx.MBeanRepresentation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@Path(value="/v1/jmx")
public class MBeanResource {
    private final MBeanServer mbeanServer;
    private final ObjectMapper objectMapper;

    @Inject
    public MBeanResource(MBeanServer mbeanServer, ObjectMapper objectMapper) {
        this.mbeanServer = mbeanServer;
        this.objectMapper = objectMapper;
    }

    @GET
    @Produces(value={"text/html"})
    public String getMBeansUi() throws Exception {
        return Resources.toString((URL)Resources.getResource(this.getClass(), (String)"mbeans.html"), (Charset)StandardCharsets.UTF_8);
    }

    @GET
    @Path(value="mbean")
    @Produces(value={"application/json"})
    public List<MBeanRepresentation> getMBeans() throws JMException {
        ImmutableList.Builder mbeans = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            mbeans.add((Object)new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper));
        }
        return mbeans.build();
    }

    @GET
    @Path(value="mbean/{objectName}")
    @Produces(value={"application/json"})
    public MBeanRepresentation getMBean(@PathParam(value="objectName") ObjectName objectName) throws JMException {
        Objects.requireNonNull(objectName, "objectName is null");
        return new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper);
    }

    @GET
    @Path(value="mbean/{objectName}/{attributeName}")
    @Produces(value={"application/json"})
    public Object getMBean(@PathParam(value="objectName") ObjectName objectName, @PathParam(value="attributeName") String attributeName) throws JMException {
        Objects.requireNonNull(objectName, "objectName is null");
        return this.mbeanServer.getAttribute(objectName, attributeName);
    }
}

