/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.testing.assertj.AbstractPointAssert;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.ValueAtQuantileAssert;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public final class SummaryPointAssert
extends AbstractPointAssert<SummaryPointAssert, SummaryPointData> {
    SummaryPointAssert(SummaryPointData actual) {
        super(actual, SummaryPointAssert.class);
    }

    public SummaryPointAssert hasCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((SummaryPointData)this.actual).getCount()).as("count", new Object[0])).isEqualTo(expected);
        return this;
    }

    public SummaryPointAssert hasSum(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((SummaryPointData)this.actual).getSum()).as("sum", new Object[0])).isEqualTo(expected);
        return this;
    }

    @SafeVarargs
    public final SummaryPointAssert hasValuesSatisfying(Consumer<ValueAtQuantileAssert> ... assertions) {
        return this.hasValuesSatisfying(Arrays.asList(assertions));
    }

    public SummaryPointAssert hasValuesSatisfying(Iterable<? extends Consumer<ValueAtQuantileAssert>> assertions) {
        Assertions.assertThat((List)((SummaryPointData)this.actual).getValues()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, ValueAtQuantileAssert::new));
        return this;
    }
}

