/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import io.trino.client.Column;
import io.trino.client.JsonDecodingUtils;
import io.trino.client.ResultRows;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class JsonResultRows {
    private static final JsonFactory JSON_FACTORY = JsonResultRows.createJsonFactory();

    private JsonResultRows() {
    }

    public static ResultRows forJsonParser(JsonParser parser, List<Column> columns) {
        return () -> {
            try {
                return new RowWiseIterator(parser, JsonDecodingUtils.createTypeDecoders(columns));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static ResultRows forInputStream(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) {
        return () -> {
            try {
                return new RowWiseIterator(stream, decoders);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @SuppressModernizer
    private static JsonFactory createJsonFactory() {
        return new JsonFactory().enable(JsonParser.Feature.USE_FAST_DOUBLE_PARSER).enable(JsonParser.Feature.USE_FAST_BIG_NUMBER_PARSER).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    private static class RowWiseIterator
    extends AbstractIterator<List<Object>> {
        private final Closer closer = Closer.create();
        private boolean closed;
        private final JsonParser parser;
        private final JsonDecodingUtils.TypeDecoder[] decoders;

        public RowWiseIterator(JsonParser parser, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            Objects.requireNonNull(decoders, "decoders is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.decoders = decoders;
            this.closer.register((Closeable)parser);
            Verify.verify((parser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of an array, but got %s", (Object)parser.currentToken());
            switch (parser.nextToken()) {
                case END_ARRAY: {
                    this.closed = true;
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                default: {
                    throw new VerifyException("Expected start of the data array, but got " + parser.currentToken());
                }
            }
        }

        public RowWiseIterator(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            this(JSON_FACTORY.createParser(Objects.requireNonNull(stream, "stream is null")), decoders);
            this.closer.register((Closeable)stream);
        }

        private void checkIfClosed() {
            try {
                Verify.verify((this.parser.nextToken() == JsonToken.END_ARRAY ? 1 : 0) != 0, (String)"Expected end of data array, but got %s", (Object)this.parser.currentToken());
                switch (this.parser.nextToken()) {
                    case END_ARRAY: {
                        this.close();
                        break;
                    }
                    case START_ARRAY: {
                        break;
                    }
                    default: {
                        throw new VerifyException("Expected end of or start of next data array, but got " + this.parser.currentToken());
                    }
                }
            }
            catch (IOException e) {
                this.closed = true;
                throw new UncheckedIOException(e);
            }
        }

        public List<Object> computeNext() {
            if (this.closed) {
                return (List)this.endOfData();
            }
            try {
                ArrayList<Object> row = new ArrayList<Object>(this.decoders.length);
                for (JsonDecodingUtils.TypeDecoder decoder : this.decoders) {
                    if (Objects.requireNonNull(this.parser.nextToken()) == JsonToken.VALUE_NULL) {
                        row.add(null);
                        continue;
                    }
                    row.add(decoder.decode(this.parser));
                }
                this.checkIfClosed();
                return Collections.unmodifiableList(row);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void close() throws IOException {
            this.closed = true;
            this.closer.close();
        }
    }
}

