/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.transaction.TransactionManager;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CoordinatorSystemTablesProvider
implements SystemTablesProvider {
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final String catalogName;
    private final StaticSystemTablesProvider staticProvider;

    public CoordinatorSystemTablesProvider(TransactionManager transactionManager, Metadata metadata, String catalogName, StaticSystemTablesProvider staticProvider) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.staticProvider = Objects.requireNonNull(staticProvider, "staticProvider is null");
    }

    @Override
    public Set<SystemTable> listSystemTables(ConnectorSession session) {
        return this.staticProvider.listSystemTables(session);
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Optional<SystemTable> staticSystemTable = this.staticProvider.getSystemTable(session, tableName);
        if (staticSystemTable.isPresent()) {
            return staticSystemTable;
        }
        if (!this.isCoordinatorTransaction(session)) {
            return Optional.empty();
        }
        Optional<SystemTable> systemTable = this.metadata.getSystemTable(((FullConnectorSession)session).getSession(), new QualifiedObjectName(this.catalogName, tableName.getSchemaName(), tableName.getTableName()));
        if (systemTable.isPresent() && systemTable.get().getDistribution() != SystemTable.Distribution.SINGLE_COORDINATOR) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Distribution for dynamic system table must be " + String.valueOf(SystemTable.Distribution.SINGLE_COORDINATOR));
        }
        return systemTable;
    }

    private boolean isCoordinatorTransaction(ConnectorSession connectorSession) {
        return Optional.of(connectorSession).filter(FullConnectorSession.class::isInstance).map(FullConnectorSession.class::cast).map(FullConnectorSession::getSession).flatMap(Session::getTransactionId).map(this.transactionManager::transactionExists).orElse(false);
    }
}

