/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class TableCommentSystemTable
implements SystemTable {
    private static final Logger LOG = Logger.get(TableCommentSystemTable.class);
    private static final SchemaTableName COMMENT_TABLE_NAME = new SchemaTableName("metadata", "table_comments");
    private static final ConnectorTableMetadata COMMENT_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(COMMENT_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("comment", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TableCommentSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return COMMENT_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)COMMENT_TABLE);
        Domain catalogDomain = constraint.getDomain((Object)0, (Type)VarcharType.VARCHAR);
        Domain schemaDomain = constraint.getDomain((Object)1, (Type)VarcharType.VARCHAR);
        Domain tableDomain = constraint.getDomain((Object)2, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(catalogDomain) || FilterUtil.isImpossibleObjectName(schemaDomain) || FilterUtil.isImpossibleObjectName(tableDomain)) {
            return table.build().cursor();
        }
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tableDomain);
        Session session = ((FullConnectorSession)connectorSession).getSession();
        for (String catalog : MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogDomain)) {
            if (schemaDomain.isNullableDiscreteSet()) {
                for (Object slice : schemaDomain.getNullableDiscreteSet().getNonNullValues()) {
                    String schemaName = ((Slice)slice).toStringUtf8();
                    if (FilterUtil.isImpossibleObjectName(schemaName)) continue;
                    this.addTableCommentForCatalog(session, table, catalog, FilterUtil.tablePrefix(catalog, Optional.of(schemaName), tableFilter));
                }
                continue;
            }
            this.addTableCommentForCatalog(session, table, catalog, FilterUtil.tablePrefix(catalog, Optional.empty(), tableFilter));
        }
        return table.build().cursor();
    }

    private void addTableCommentForCatalog(Session session, InMemoryRecordSet.Builder table, String catalog, QualifiedTablePrefix prefix) {
        block7: {
            block6: {
                RelationComment relationComment;
                if (!prefix.getTableName().isPresent()) break block6;
                QualifiedObjectName relationName = new QualifiedObjectName(catalog, prefix.getSchemaName().orElseThrow(), prefix.getTableName().get());
                try {
                    relationComment = this.getRelationComment(session, relationName);
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to get comment for relation: %s", new Object[]{relationName});
                    relationComment = new RelationComment(false, Optional.empty());
                }
                if (!relationComment.found()) break block7;
                SchemaTableName schemaTableName = relationName.asSchemaTableName();
                if (!this.accessControl.filterTables(session.toSecurityContext(), catalog, (Set<SchemaTableName>)ImmutableSet.of((Object)schemaTableName)).contains(schemaTableName)) break block7;
                table.addRow(new Object[]{catalog, schemaTableName.getSchemaName(), schemaTableName.getTableName(), relationComment.comment().orElse(null)});
                break block7;
            }
            AtomicInteger filteredCount = new AtomicInteger();
            List<RelationCommentMetadata> relationComments = this.metadata.listRelationComments(session, prefix.getCatalogName(), prefix.getSchemaName(), relationNames -> {
                Set<SchemaTableName> filtered = this.accessControl.filterTables(session.toSecurityContext(), catalog, (Set<SchemaTableName>)relationNames);
                filteredCount.addAndGet(filtered.size());
                return filtered;
            });
            Preconditions.checkState((filteredCount.get() >= relationComments.size() ? 1 : 0) != 0, (String)"relationFilter is mandatory, but it has not been called for some of returned relations: returned %s relations, %s passed the filter", (int)relationComments.size(), (int)filteredCount.get());
            for (RelationCommentMetadata commentMetadata : relationComments) {
                SchemaTableName name = commentMetadata.name();
                if (!commentMetadata.tableRedirected()) {
                    table.addRow(new Object[]{catalog, name.getSchemaName(), name.getTableName(), commentMetadata.comment().orElse(null)});
                    continue;
                }
                try {
                    RelationComment relationComment = this.getTableCommentRedirectionAware(session, new QualifiedObjectName(catalog, name.getSchemaName(), name.getTableName()));
                    if (!relationComment.found()) continue;
                    table.addRow(new Object[]{catalog, name.getSchemaName(), name.getTableName(), relationComment.comment().orElse(null)});
                }
                catch (RuntimeException e) {
                    LOG.warn((Throwable)e, "Failed to get metadata for redirected table: %s", new Object[]{name});
                }
            }
        }
    }

    private RelationComment getRelationComment(Session session, QualifiedObjectName relationName) {
        Optional<MaterializedViewDefinition> materializedView = this.metadata.getMaterializedView(session, relationName);
        if (materializedView.isPresent()) {
            return new RelationComment(true, materializedView.get().getComment());
        }
        Optional<ViewDefinition> view = this.metadata.getView(session, relationName);
        if (view.isPresent()) {
            return new RelationComment(true, view.get().getComment());
        }
        return this.getTableCommentRedirectionAware(session, relationName);
    }

    private RelationComment getTableCommentRedirectionAware(Session session, QualifiedObjectName relationName) {
        RedirectionAwareTableHandle redirectionAware = this.metadata.getRedirectionAwareTableHandle(session, relationName);
        if (redirectionAware.tableHandle().isEmpty()) {
            return new RelationComment(false, Optional.empty());
        }
        if (redirectionAware.redirectedTableName().isPresent()) {
            QualifiedObjectName redirectedRelationName = redirectionAware.redirectedTableName().get();
            SchemaTableName redirectedTableName = redirectedRelationName.asSchemaTableName();
            if (!this.accessControl.filterTables(session.toSecurityContext(), redirectedRelationName.catalogName(), (Set<SchemaTableName>)ImmutableSet.of((Object)redirectedTableName)).contains(redirectedTableName)) {
                return new RelationComment(false, Optional.empty());
            }
        }
        return new RelationComment(true, this.metadata.getTableMetadata(session, redirectionAware.tableHandle().get()).metadata().getComment());
    }

    private record RelationComment(boolean found, Optional<String> comment) {
        RelationComment {
            Objects.requireNonNull(comment, "comment is null");
            Preconditions.checkArgument((found || comment.isEmpty() ? 1 : 0) != 0, (Object)"Unexpected comment for a relation that is not found");
        }
    }
}

