/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.trino.execution.ExecutionFailureInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Failure
extends RuntimeException {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final ExecutionFailureInfo failureInfo;

    Failure(ExecutionFailureInfo failureInfo) {
        super(failureInfo.getMessage(), failureInfo.getCause() == null ? null : new Failure(failureInfo.getCause()));
        this.failureInfo = failureInfo;
        for (ExecutionFailureInfo suppressed : failureInfo.getSuppressed()) {
            this.addSuppressed(new Failure(suppressed));
        }
        this.setStackTrace((StackTraceElement[])failureInfo.getStack().stream().map(Failure::toStackTraceElement).toArray(StackTraceElement[]::new));
    }

    public ExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Override
    public String toString() {
        String type = this.getFailureInfo().getType();
        String message = this.getMessage();
        if (message != null) {
            return type + ": " + message;
        }
        return type;
    }

    private static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

