/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.PipelinedBufferInfo;
import io.trino.operator.TaskStats;
import io.trino.sql.planner.plan.PlanNodeId;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;

public record TaskInfo(TaskStatus taskStatus, DateTime lastHeartbeat, OutputBufferInfo outputBuffers, Set<PlanNodeId> noMoreSplits, TaskStats stats, Optional<DataSize> estimatedMemory, boolean needsPlan) {
    public TaskInfo {
        Objects.requireNonNull(taskStatus, "taskStatus is null");
        Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Objects.requireNonNull(noMoreSplits, "noMoreSplits is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(estimatedMemory, "estimatedMemory is null");
    }

    public TaskInfo summarize() {
        if (this.taskStatus.getState().isDone()) {
            return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarizeFinal(), this.noMoreSplits, this.stats.summarizeFinal(), this.estimatedMemory, this.needsPlan);
        }
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.summarize(), this.noMoreSplits, this.stats.summarize(), this.estimatedMemory, this.needsPlan);
    }

    public TaskInfo pruneSpoolingOutputStats() {
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers.pruneSpoolingOutputStats(), this.noMoreSplits, this.stats, this.estimatedMemory, this.needsPlan);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskStatus.getTaskId()).add("state", (Object)this.taskStatus.getState()).toString();
    }

    public static TaskInfo createInitialTask(TaskId taskId, URI location, String nodeId, boolean speculative, Optional<List<PipelinedBufferInfo>> pipelinedBufferStates, TaskStats taskStats) {
        return new TaskInfo(TaskStatus.initialTaskStatus(taskId, location, nodeId, speculative), DateTime.now(), new OutputBufferInfo("UNINITIALIZED", BufferState.OPEN, true, true, 0L, 0L, 0L, 0L, pipelinedBufferStates, Optional.empty(), Optional.empty()), (Set<PlanNodeId>)ImmutableSet.of(), taskStats, Optional.empty(), true);
    }

    public TaskInfo withTaskStatus(TaskStatus newTaskStatus) {
        return new TaskInfo(newTaskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, this.estimatedMemory, this.needsPlan);
    }

    public TaskInfo withEstimatedMemory(DataSize estimatedMemory) {
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, Optional.of(estimatedMemory), this.needsPlan);
    }
}

