/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.airlift.compress.v3.lz4.Lz4Compressor;
import io.airlift.compress.v3.zstd.ZstdCompressor;
import java.util.OptionalInt;

public enum CompressionCodec {
    NONE,
    LZ4,
    ZSTD;


    public OptionalInt maxCompressedLength(int inputSize) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> OptionalInt.empty();
            case 1 -> OptionalInt.of(Lz4Compressor.create().maxCompressedLength(inputSize));
            case 2 -> OptionalInt.of(ZstdCompressor.create().maxCompressedLength(inputSize));
        };
    }
}

