/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Preconditions;
import io.trino.likematcher.Matcher;
import io.trino.likematcher.Pattern;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FjsMatcher
implements Matcher {
    private final List<Pattern> pattern;
    private final int start;
    private final int end;
    private final boolean exact;
    private volatile Fjs matcher;

    public FjsMatcher(List<Pattern> pattern, int start, int end, boolean exact) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.start = start;
        this.end = end;
        this.exact = exact;
    }

    @Override
    public boolean match(byte[] input, int offset, int length) {
        Fjs matcher = this.matcher;
        if (matcher == null) {
            this.matcher = matcher = new Fjs(this.pattern, this.start, this.end, this.exact);
        }
        return matcher.match(input, offset, length);
    }

    private static class Fjs {
        private final boolean exact;
        private final List<byte[]> patterns = new ArrayList<byte[]>();
        private final List<int[]> bmsShifts = new ArrayList<int[]>();
        private final List<int[]> kmpShifts = new ArrayList<int[]>();

        public Fjs(List<Pattern> pattern, int start, int end, boolean exact) {
            this.exact = exact;
            block4: for (int i = start; i <= end; ++i) {
                Pattern element;
                Pattern pattern2 = element = pattern.get(i);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pattern.Literal.class, Pattern.Any.class}, (Pattern)pattern2, n)) {
                    case 0: {
                        Pattern.Literal literal = (Pattern.Literal)pattern2;
                        Preconditions.checkArgument((i == 0 || !(pattern.get(i - 1) instanceof Pattern.Literal) ? 1 : 0) != 0, (Object)"Multiple consecutive literals found");
                        byte[] bytes = literal.value().getBytes(StandardCharsets.UTF_8);
                        this.patterns.add(bytes);
                        this.bmsShifts.add(Fjs.computeBmsShifts(bytes));
                        this.kmpShifts.add(Fjs.computeKmpShifts(bytes));
                        continue block4;
                    }
                    case 1: {
                        Pattern.Any any = (Pattern.Any)pattern2;
                        throw new IllegalArgumentException("'any' pattern not supported");
                    }
                }
            }
        }

        private static int[] computeKmpShifts(byte[] pattern) {
            int[] result = new int[pattern.length + 1];
            result[0] = -1;
            int j = -1;
            for (int i = 1; i < result.length; ++i) {
                while (j >= 0 && pattern[i - 1] != pattern[j]) {
                    j = result[j];
                }
                result[i] = ++j;
            }
            return result;
        }

        private static int[] computeBmsShifts(byte[] pattern) {
            int[] result = new int[256];
            for (int i = 0; i < pattern.length; ++i) {
                result[pattern[i] & 0xFF] = i + 1;
            }
            return result;
        }

        private static int find(byte[] input, int offset, int length, byte[] pattern, int[] bmsShifts, int[] kmpShifts) {
            if (pattern.length > length || pattern.length == 0) {
                return -1;
            }
            int inputLimit = offset + length;
            int i = offset;
            while (true) {
                int matchEnd;
                int shift;
                for (matchEnd = i + pattern.length - 1; matchEnd < inputLimit - 1 && input[matchEnd] != pattern[pattern.length - 1]; matchEnd += shift) {
                    shift = pattern.length + 1 - bmsShifts[input[matchEnd + 1] & 0xFF];
                }
                if (matchEnd == inputLimit - 1 && Fjs.match(input, inputLimit - pattern.length, pattern)) {
                    return inputLimit - pattern.length;
                }
                if (matchEnd >= inputLimit - 1) {
                    return -1;
                }
                i = matchEnd - (pattern.length - 1);
                int j = Fjs.findLongestMatch(input, i, pattern, 0, pattern.length - 1);
                if (j == pattern.length - 1) {
                    return i;
                }
                i += j;
                j = kmpShifts[j];
                while (j >= 0) {
                    int size = Fjs.findLongestMatch(input, i, pattern, j, Math.min(inputLimit - i, pattern.length - j));
                    i += size;
                    if ((j += size) == pattern.length) {
                        return i - j;
                    }
                    j = kmpShifts[j];
                }
                ++i;
            }
        }

        private static int findLongestMatch(byte[] input, int inputOffset, byte[] pattern, int patternOffset, int length) {
            for (int i = 0; i < length; ++i) {
                if (input[inputOffset + i] == pattern[patternOffset + i]) continue;
                return i;
            }
            return length;
        }

        private static boolean match(byte[] input, int offset, byte[] pattern) {
            for (int i = 0; i < pattern.length; ++i) {
                if (input[offset + i] == pattern[i]) continue;
                return false;
            }
            return true;
        }

        public boolean match(byte[] input, int offset, int length) {
            int start = offset;
            int remaining = length;
            for (int i = 0; i < this.patterns.size(); ++i) {
                if (remaining == 0) {
                    return false;
                }
                byte[] term = this.patterns.get(i);
                int position = Fjs.find(input, start, remaining, term, this.bmsShifts.get(i), this.kmpShifts.get(i));
                if (position == -1) {
                    return false;
                }
                remaining -= (position += term.length) - start;
                start = position;
            }
            return !this.exact || remaining == 0;
        }
    }
}

