/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TotalReservationOnBlockedNodesQueryLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<KillTarget> chooseTargetToKill(List<LowMemoryKiller.RunningQueryInfo> runningQueries, List<MemoryInfo> nodes) {
        ImmutableMap queriesById = Maps.uniqueIndex(runningQueries, LowMemoryKiller.RunningQueryInfo::getQueryId);
        HashMap memoryReservationOnBlockedNodes = new HashMap();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            Map queryMemoryReservations = memoryPool.getQueryMemoryReservations();
            queryMemoryReservations.forEach((arg_0, arg_1) -> TotalReservationOnBlockedNodesQueryLowMemoryKiller.lambda$chooseTargetToKill$1((Map)queriesById, memoryReservationOnBlockedNodes, arg_0, arg_1));
        }
        return memoryReservationOnBlockedNodes.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).map(KillTarget::wholeQuery);
    }

    private static /* synthetic */ void lambda$chooseTargetToKill$1(Map queriesById, Map memoryReservationOnBlockedNodes, QueryId queryId, Long memoryReservation) {
        LowMemoryKiller.RunningQueryInfo queryMemoryInfo = (LowMemoryKiller.RunningQueryInfo)queriesById.get(queryId);
        if (queryMemoryInfo != null && queryMemoryInfo.getRetryPolicy() == RetryPolicy.TASK) {
            return;
        }
        memoryReservationOnBlockedNodes.compute(queryId, (id, oldValue) -> oldValue == null ? memoryReservation : oldValue + memoryReservation);
    }
}

