/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import java.util.Objects;
import java.util.Optional;

public record RedirectionAwareTableHandle(Optional<TableHandle> tableHandle, Optional<QualifiedObjectName> redirectedTableName) {
    public RedirectionAwareTableHandle {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(redirectedTableName, "redirectedTableName is null");
        Preconditions.checkArgument((tableHandle.isPresent() || redirectedTableName.isEmpty() ? 1 : 0) != 0, (Object)"redirectedTableName present without tableHandle");
    }

    public static RedirectionAwareTableHandle withRedirectionTo(QualifiedObjectName redirectedTableName, TableHandle tableHandle) {
        return new RedirectionAwareTableHandle(Optional.of(tableHandle), Optional.of(redirectedTableName));
    }

    public static RedirectionAwareTableHandle noRedirection(Optional<TableHandle> tableHandle) {
        return new RedirectionAwareTableHandle(tableHandle, Optional.empty());
    }
}

